package com.icetech.paycenter.domain.request.wx;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 微信进件提交申请类
 * @author kate
 */
@Data
public class WxApplySubmitRequest implements Serializable {
    @NotNull
    private Integer parkId;
    /**
     * 申请编号
     */
    private String applyCode;
    /**
     * 超级管理员信息
     */

    /**
     * 超级管理员姓名
     */
    @NotNull
    private String contactName;
    /**
     * 超级管理员身份证号
     */
    @NotNull
    private String contactIdNumber;
    /**
     *联系手机
     */
    @NotNull
    private String mobilePhone;
    /**
     * 联系邮箱
     */
    @NotNull
    private String contactEmail;
    @NotNull
    private String parkAddressCode;
    @NotNull
    private String parkAddressName;
    @NotNull
    private String parkAddress;

    /**
     * 主体信息
     */
    /**
     * 营业执照照片
     */
    @NotNull
    private String licenseCopy;
    /**
     * 注册号/统一社会信用代码
     */
    @NotNull
    private String licenseNumber;
    /**
     * 商户名称
     */
    @NotNull
    private String merchantName;
    /**
     *个体户经营者/法人姓名
     */
    @NotNull
    private String legalPerson;
    /**
     * 身份证人像面照片
     */
    @NotNull
    private String idCardCopy;
    /**
     * 身份证国徽面照片
     */
    @NotNull
    private String idCardNational;
    /**
     * 身份证姓名
     */
    @NotNull
    private String idCardName;
    /**
     * 身份证号码
     */
    @NotNull
    private String idCardNumber;
    /**
     * 身份证有效期开始时间
     */
    @NotNull
    private String cardPeriodBegin;
    /**
     * 身份证有效期结束时间
     */
    @NotNull
    private String cardPeriodEnd;

    /**
     * 经营信息
     */
    /**
     * 商户简称
     */
    @NotNull
    private String merchantShortname;
    /**
     * 客服电话
     */
    @NotNull
    private String servicePhone;
    /**
     * 门店照片
     */
    @NotNull
    private String storeEntrancePic;
    /**
     * 店内环境照片
     */
    @NotNull
    private String indoorPic;

    /**
     * 账户信息
     */
    /**
     * 开户名称
     */
    @NotNull
    private String accountName;
    /**
     * 开户银行
     */
    @NotNull
    private String accountBank;
    /**
     * 开户银行省市编码
     */
    @NotNull
    private String bankAddressCode;
    @NotNull
    private String bankAddressName;
    /**
     * 开户支行
     */
    @NotNull
    private String bankName;
    /**
     * 银行账号
     */
    @NotNull
    private String accountNumber;
}
