package com.icetech.paycenter.domain.request.lkl;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Set;

/**
 * 拉卡拉进件异步通知
 * @author wangzhiwei
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class NotifyInputReqModel implements Serializable {
    private String code;
    private String message;
    private NotifyDetail data;


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class NotifyDetail implements Serializable{
        private String orgCode;
        private String orderNo;
        private String contractId;
        private String contractStatus;
        private String contractMemo;
        private String merInnerNo;
        private String merCupNo;
        private Set<TermData> termDatas;
    }
}
