package com.icetech.paycenter.domain.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 对账请求参数
 * @author fangct
 */
@Data
public class ReconciliationRequest implements Serializable {
    /**
     *车场id
     */
    private String parkCode;
    /**
     * 开始时间
     */
    @NotNull
    @JSONField(format = "yyyy-MM-dd")
    private Date startTime;
    /**
     *结束时间
     */
    @NotNull
    @JSONField(format = "yyyy-MM-dd")
    private Date endTime;
    /**
     * 接口名称
     */
    @NotNull
    private String serverName;
}
