package com.icetech.paycenter.domain.normalpay.request;


import com.icetech.common.annotation.NotNull;
import com.icetech.common.constants.PayWayContants;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 统一下单接口请求
 */
@Getter
@Setter
@ToString
public class UnifiedOrderRequest implements Serializable {

    /**
     * 停车场编号，由支付中心统一分配
     */
    @NotNull
    private String parkCode;
    /**
     * 小程序支付时的appid
     */
    private String appId;

    /**
     * 交易流水号
     */
    @NotNull
    private String tradeNo;

    /**
     * 下单交易类型
     */
    @NotNull
    private String selectTradeType;

    /**
     * 商品名称
     */
    @NotNull
    private String productInfo;
    /**
     *支付金额，单位为分
     */
    @NotNull
    private String price;

    /**
     *支付结果主动通知地址
     */
    @Deprecated
    private String notifyUrl;

    /**
     * 支付完成跳转地址
     */
    private String retUrl;

    /**
     *微信支付授权码，微信公众号支付时必传
     */
    @Deprecated
    private String wxCode;

    /**
     *支付宝支付授权码，支付宝服务窗下必传PayCenter4WxServiceImpl
     */
    @Deprecated
    private String aliCode;

    /**
     * 微信下用户唯一标识
     */
    private String openId;

    /**
     * 支付宝下用户的唯一标识
     */
    private String userId;
    /**
     * 渠道下用户唯一标识
     */
    private String unionId;

    /**
     * 云闪付下用户的唯一标识
     */
    private String ysfUserId;

    /**
     * 支付方式:2微信;3支付宝;4云闪付
     */
    private Integer payWay;

    /**
     * 付款码 所有反扫情况下必填
     */
    private String payCode;

    /**
     * 设备信息
     */
    private String deviceInfo;

    /**
     * 下单与支付 ip 必须保持一致
     */
    private String spbillCreateIp;

    /**
     * 微信H5 支付时的场景上报信息，H5支付为必填
     */
    private  String sceneInfo;

    /**
     * 额外信息 (异步通知的时候会全部返回)
     */
    private String extraInfo;

    /**
     * 第三方pid 默认是云平台PID
     */
    private String pid = "P001";
    /**
     * 下单版本号
     */
    private String version;
    /**
     * 车场ID
     */
    private Long parkId;
    /**
     * 0-该笔订单不允许分账[默认], 1-支付成功按配置自动完成分账, 2-商户手动分账(解冻商户金额)，当使用代理商模式进件的为只能为1
     */
    private Integer divisionMode;
    /**
     * 分账的非欠费部分的金额，单位分，有欠费追缴分成模式时必传
     */
    private Long freezeAmount;
    /**
     * 分账的知位支付规则编号，有欠费追缴分成模式时必传
     */
    private String groupId;

    /**
     * 根据付款码获取是微信还是支付宝
     * @param payCode
     * @return
     */
    public static int getWxAliPayCode(String payCode) {
        if (payCode.length() == 18 && (
                payCode.startsWith("10") || payCode.startsWith("11") || payCode.startsWith("12") || payCode.startsWith("13")
                        || payCode.startsWith("14") || payCode.startsWith("15")
        )) {
            return PayWayContants.WECHAT;
        } else {
            return PayWayContants.ALIPAY;
        }
    }

    /*
     * 生成商品信息
     */
    public String genProductInfo(String parkName, String plateNum, String feeType) {
        StringBuilder productInfo = new StringBuilder();
        if (StringUtils.isNotBlank(parkName)) {
            productInfo.append(parkName);
        }
        if (StringUtils.isNotBlank(plateNum)) {
            productInfo.append("-").append(plateNum);
        }
        if (StringUtils.isNotBlank(feeType)) {
            productInfo.append("-").append(feeType);
        }
        if (productInfo.toString().startsWith("-")) {
            productInfo.deleteCharAt(0);
        }
        return productInfo.toString();
    }
}
