package com.icetech.paycenter.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.paycenter.domain.PlatformPayType;
import com.icetech.paycenter.domain.normalpay.request.HzfiedOrderRequest;
import com.icetech.paycenter.domain.normalpay.request.PayResultRequest;
import com.icetech.paycenter.domain.normalpay.request.RefundRequest;
import com.icetech.paycenter.domain.normalpay.request.UnifiedOrderRequest;
import com.icetech.paycenter.domain.normalpay.response.PayResultResponse;
import com.icetech.paycenter.domain.normalpay.response.RefundResponse;
import com.icetech.paycenter.domain.normalpay.response.UnifiedOrderResponse;
import com.icetech.paycenter.domain.request.AliParkingEnterRequest;
import com.icetech.paycenter.domain.request.AliParkingExitRequest;
import com.icetech.paycenter.domain.request.autopay.EnterNotifyRequest;
import com.icetech.paycenter.domain.request.autopay.ExitNotifyRequest;
import com.icetech.paycenter.domain.request.autopay.ExitpayRequest;

/**
 * 支付中心 支付 接口
 * @author wangzw
 */
public interface IPayCenterService {

    /**
     * 入场通知
     * @param request 请求参数
     * @return
     */
    ObjectResponse<String> autoPayEnterNotify(EnterNotifyRequest request);

    /**
     * 离场通知
     * @param request 请求参数
     * @return
     */
    ObjectResponse<String> autoPayExitNotify(ExitNotifyRequest request);
    /**
     * 离场免密支付
     * @param exitpayRequest
     * @return
     */
    ObjectResponse autopay(ExitpayRequest exitpayRequest);

    /**
     * 统一下单
     * @param unifiedOrderRequest
     * @return
     */
    ObjectResponse<UnifiedOrderResponse> doUnifiedOrder(UnifiedOrderRequest unifiedOrderRequest);

    /**
     * 退款接口
     * @param request
     * @return
     */
    ObjectResponse<RefundResponse> refund(RefundRequest request);

    /**
     * 查询微信支付宝 支付结果
     * @param request 支付结果查询请求
     * @param tradeType 支付类型
     * @return
     */
    ObjectResponse<PayResultResponse> getPayResult(PayResultRequest request,String tradeType);

    ObjectResponse<String> getPayResult(String tradeNo);

    /**
     * 获取当前车厂支持的支付类型
     * @param parkCode
     * @param payType
     * @return 0=不支持 1=微信 2=支付宝 3=聚合 4云闪付聚合
     */
    ObjectResponse<Integer> getSupportPayType(String parkCode, PlatformPayType payType);

    /**
     * 添加交易流水记录
     * @param unifiedOrderRequest
     * @return
     */
    ObjectResponse addaccountRecord(HzfiedOrderRequest unifiedOrderRequest);


    /**
     * 阿里入场
     */
    ObjectResponse aliParkingEnter(AliParkingEnterRequest aliParkingEnterRequest);
    /**
     * 阿里离场
     */
    ObjectResponse aliParkingExit(AliParkingExitRequest parkingExitRequest);

    /**
     * 获取广告接口
     * @param userIp
     * @param userAgent
     * @param type
     * @return
     */
    ObjectResponse getAdVert(String userIp,String userAgent,Integer type);
}
