/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.paycenter.domain.normalpay.request;

import com.icetech.common.annotation.NotNull;
import com.icetech.common.constants.PayWayContants;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class UnifiedOrderRequest
implements Serializable {
    @NotNull
    private String parkCode;
    private String appId;
    @NotNull
    private String tradeNo;
    @NotNull
    private String selectTradeType;
    @NotNull
    private String productInfo;
    @NotNull
    private String price;
    @Deprecated
    private String notifyUrl;
    private String retUrl;
    @Deprecated
    private String wxCode;
    @Deprecated
    private String aliCode;
    private String openId;
    private String userId;
    private String unionId;
    private String ysfUserId;
    private Integer payWay;
    private String payCode;
    private String deviceInfo;
    private String spbillCreateIp;
    private String sceneInfo;
    private String extraInfo;
    private String pid = "P001";
    private String version;
    private Long parkId;
    private Integer divisionMode;
    private Long freezeAmount;
    private String groupId;

    public static int getWxAliPayCode(String payCode) {
        if (payCode.length() == 18 && (payCode.startsWith("10") || payCode.startsWith("11") || payCode.startsWith("12") || payCode.startsWith("13") || payCode.startsWith("14") || payCode.startsWith("15"))) {
            return PayWayContants.WECHAT;
        }
        return PayWayContants.ALIPAY;
    }

    public String genProductInfo(String parkName, String plateNum, String feeType) {
        StringBuilder productInfo = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)parkName)) {
            productInfo.append(parkName);
        }
        if (StringUtils.isNotBlank((CharSequence)plateNum)) {
            productInfo.append("-").append(plateNum);
        }
        if (StringUtils.isNotBlank((CharSequence)feeType)) {
            productInfo.append("-").append(feeType);
        }
        if (productInfo.toString().startsWith("-")) {
            productInfo.deleteCharAt(0);
        }
        return productInfo.toString();
    }

    public String getParkCode() {
        return this.parkCode;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public String getSelectTradeType() {
        return this.selectTradeType;
    }

    public String getProductInfo() {
        return this.productInfo;
    }

    public String getPrice() {
        return this.price;
    }

    @Deprecated
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getRetUrl() {
        return this.retUrl;
    }

    @Deprecated
    public String getWxCode() {
        return this.wxCode;
    }

    @Deprecated
    public String getAliCode() {
        return this.aliCode;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public String getYsfUserId() {
        return this.ysfUserId;
    }

    public Integer getPayWay() {
        return this.payWay;
    }

    public String getPayCode() {
        return this.payCode;
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getSpbillCreateIp() {
        return this.spbillCreateIp;
    }

    public String getSceneInfo() {
        return this.sceneInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public String getPid() {
        return this.pid;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getParkId() {
        return this.parkId;
    }

    public Integer getDivisionMode() {
        return this.divisionMode;
    }

    public Long getFreezeAmount() {
        return this.freezeAmount;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setSelectTradeType(String selectTradeType) {
        this.selectTradeType = selectTradeType;
    }

    public void setProductInfo(String productInfo) {
        this.productInfo = productInfo;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Deprecated
    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setRetUrl(String retUrl) {
        this.retUrl = retUrl;
    }

    @Deprecated
    public void setWxCode(String wxCode) {
        this.wxCode = wxCode;
    }

    @Deprecated
    public void setAliCode(String aliCode) {
        this.aliCode = aliCode;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public void setYsfUserId(String ysfUserId) {
        this.ysfUserId = ysfUserId;
    }

    public void setPayWay(Integer payWay) {
        this.payWay = payWay;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public void setSceneInfo(String sceneInfo) {
        this.sceneInfo = sceneInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setParkId(Long parkId) {
        this.parkId = parkId;
    }

    public void setDivisionMode(Integer divisionMode) {
        this.divisionMode = divisionMode;
    }

    public void setFreezeAmount(Long freezeAmount) {
        this.freezeAmount = freezeAmount;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String toString() {
        return "UnifiedOrderRequest(parkCode=" + this.getParkCode() + ", appId=" + this.getAppId() + ", tradeNo=" + this.getTradeNo() + ", selectTradeType=" + this.getSelectTradeType() + ", productInfo=" + this.getProductInfo() + ", price=" + this.getPrice() + ", notifyUrl=" + this.getNotifyUrl() + ", retUrl=" + this.getRetUrl() + ", wxCode=" + this.getWxCode() + ", aliCode=" + this.getAliCode() + ", openId=" + this.getOpenId() + ", userId=" + this.getUserId() + ", unionId=" + this.getUnionId() + ", ysfUserId=" + this.getYsfUserId() + ", payWay=" + this.getPayWay() + ", payCode=" + this.getPayCode() + ", deviceInfo=" + this.getDeviceInfo() + ", spbillCreateIp=" + this.getSpbillCreateIp() + ", sceneInfo=" + this.getSceneInfo() + ", extraInfo=" + this.getExtraInfo() + ", pid=" + this.getPid() + ", version=" + this.getVersion() + ", parkId=" + this.getParkId() + ", divisionMode=" + this.getDivisionMode() + ", freezeAmount=" + this.getFreezeAmount() + ", groupId=" + this.getGroupId() + ")";
    }
}

