package com.icetech.paycenter.domain.response.lkl;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 车场拉卡拉支付进件表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-04-24
 */
@Data
public class InputResModel implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id (主健自增)
     */
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 申请单类型 1=自然人 2=个体工商户对私 3=个体工商户对公 4=企业
     */
    private Integer applyType;
    /**
     * 是否法人收款 1=是 0=否
     */
    private Integer frAccount;

    /**
     * 进件申请单号
     */
    private String orderNo;

    /**
     * 电子合同编号
     */
    private String contractNo;

    /**
     * 进件id(进件成功之后返回)
     */
    private String contractId;

    /**
     * 商户注册名称
     */
    private String merRegName;

    /**
     * 商户经营名称
     */
    private String merBizName;

    /**
     * 商户地区代码
     */
    private String merRegDistCode;

    /**
     * 商户省代码
     */
    private String merRegProvinceCode;
    /**
     * 商户城市代码
     */
    private String merRegCityCode;

    /**
     * 商户详细地址
     */
    private String merRegAddr;

    /**
     * 商户MCC编号
     */
    private String mccCode;

    /**
     * 营业执照名称
     */
    private String merBlisName;

    /**
     * 营业执照号
     */
    private String merBlis;

    /**
     * 营业执照开始日期
     */
    private LocalDate merBlisStDt;

    /**
     * 营业执照结束有日期
     */
    private LocalDate merBlisExpDt;

    /**
     * 商户经营内容
     */
    private String merBusiContent;

    /**
     * 商户法人姓名
     */
    private String larName;

    /**
     * 法人证件类型 身份证	01
护照	02
港澳通行证	03
台胞证	04
其它证件	9
     */
    private String larIdType;

    /**
     * 法人身份证号码
     */
    private String larIdCard;

    /**
     * 法人身份证开始日期
     */
    private LocalDate larIdcardStDt;

    /**
     * 法人身份证有效期
     */
    private LocalDate larIdcardExpDt;

    /**
     * 商户联系人手机号码
     */
    private String merContactMobile;

    /**
     * 商户联系人
     */
    private String merContactName;

    /**
     * 结算账户开户行号
     */
    private String openningBankCode;

    /**
     * 结算账户开户行名称
     */
    private String openningBankName;

    /**
     * 结算账户清算行号
     */
    private String clearingBankCode;

    /**
     * 结算账户账号
     */
    private String acctNo;

    /**
     * 结算账户名称
     */
    private String acctName;

    /**
     * 结算账户性质	57 对公
58 对私
     */
    private String acctTypeCode;
    /**
     * 身份证 01 护照	02 港澳通行证	03 台胞证 04 其它证件	99
     */
    private String acctIdType;
    /**
     * 结算人证件号
     */
    private String acctIdcard;

    /**
     * 场内照片
     */
    private String indoorPic;
    /**
     * 收银台照片
     */
    private String cashPic;

    /**
     * 车场照片
     */
    private String storePic;

    /**
     * 营业执照照片
     */
    private String licensePic;

    /**
     * 身份证正面照片
     */
    private String idCardFront;

    /**
     * 身份证反面照片
     */
    private String idCardBack;
    /**
     * 法人身份证正面
     */
    private String frIdCardFront;
    /**
     * 法人身份证反面
     */
    private String frIdCardBack;

    /**
     * 银行卡照片信息
     */
    private String bankPic;
    /**
     * 开户许可证照片
     */
    private String bankLicensePic;

    /**
     * 委托关系证明
     */
    private String entrustmentProvePic;
    /**
     * 入账关系证明
     */
    private String recordingProvePic;

    /**
     * 结算账户类型 57 对公 58 对私
     */
    private String accountType;


    /**
     * 支付开通状态 1.未开通2.审批中3.被驳回4.已开通
     */
    private Integer status;

    /**
     * 合同申请状态 1.申请中 2.未完成3.已完成
     */
    private Integer contractStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 拉卡拉内部商户号
     */

    private String merinnerNo;

    /**
     * 银联商户号
     */
    private String merCupNo;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 操作时间
     */
    private Date updateTime;

    /**
     * 操作人
     */
    private String editer;


}
