package com.icetech.paycenter.domain.normalpay.response;


import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 统一下单接口响应
 */
@Getter
@Setter
public class UnifiedOrderResponse implements Serializable {

    /**
     * 支付要素
     */
    private String payInfo;
    /**
     * Map 类型的支付要素
     */
    private Map mapPayInfo;
    /**
     * 支付状态
     */
    private String tradeStatus;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 第三方支付交易流水号
     */
    private String outTradeNo;
    /**
     * 下单方式
     */
    private String tradeType;
    private Boolean isZero = Boolean.FALSE;

    /**
     * 银行单号
     */
    private String bankOrderId;

    /**
     * 三方交易流水号
     */
    private String thirdTradeNo;
}
