package com.icetech.paycenter.domain.normalpay.request;


import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 河南慧众下单口请求
 */
@Getter
@Setter
@ToString
public class HzfiedOrderRequest implements Serializable {

    /**
     * 停车场编号，由支付中心统一分配
     */
    @NotNull
    private String parkCode;

    /**
     * 交易流水号
     */
    @NotNull
    private String tradeNo;

    /**
     * 下单交易类型
     */
    @NotNull
    private String selectTradeType;


    /**
     *支付金额，单位为分
     */
    @NotNull
    private int price;
    /**
     * 附加信息
     */
    private String centerInfo;

}
