package com.icetech.paycenter.domain;

import com.icetech.common.constants.PayAisleEnum;
import com.icetech.common.constants.PayMethodContants;
import com.icetech.common.constants.PayWayContants;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.io.Serializable;

/**
 * 平台支持的支付类型
 * @author wangzw
 *
 */
@AllArgsConstructor
public enum PlatformPayType implements Serializable {


    WX_ALI_PAY("WX_ALI_PAY","微信支付宝直连支付类型","WX-JSAPI/ALI-JSAPI/WX-MINI/ALI-MINI","WX-MICRO/ALI-MICRO",-1),
    CCB_PAY("CCB_PAY","建设银行聚合支付","CCB-QRCODE","CCB-SCAN",3),
    ABC_PAY("ABC_PAY","农业银行聚合支付","ABC-QRCODE","ABC-SCAN",4),
    YZ_PAY("YZ_PAY","云纵聚合支付","YZ-JSAPI/YZ-MINI","YZ-SCAN",5),
    GS_PAY("GANSU_PAY","甘肃银行聚合支付","GANSU-QRCODE","GANSU-SCAN",7),
    FJ_PAY("FJ_PAY","福建农商行聚合支付","FJ-QRCODE","",8),
    ICBC_PAY("ICBC_PAY","工商银行聚合支付","ICBC-QRCODE","",9),
    LANZHOU_PAY("LANZHOU_PAY","兰州银行聚合支付","LANZHOU-QRCODE","",10),
    COPS_PAY("COPS_PAY","广发银行聚合支付","COPS-QRCODE","COPS-SCAN",11),
    WLK_PAY("WLK_PAY","网联客聚合支付","WLK-QRCODE","WLK-SCAN",12),
    ZJ_PAY("ZJ_PAY","浙江农商行聚合支付","ZJ-QRCODE","ZJ-SCAN",13),
    CEB_PAY("CEB_PAY","光大银行聚合支付","CEB-QRCODE","CEB-SCAN",14),
    LKL_PAY("LKL_PAY","拉卡拉聚合支付","LKL-QRCODE/LKL-MINI","LKL-SCAN",15),
    GD_PAY("GD_PAY","广电银行支付","GD-QRCODE","GD-SCAN",16),
    YN_PAY("YN_PAY","云南农信支付","YN-QRCODE","YN-SCAN",17),
    PP_PAY("PP_PAY","PP支付","PP-QRCODE/PP-MINI","PP-SCAN",18),
    JH_PAY("JH_PAY","交行惠民支付","JH-QRCODE","JH-SCAN",19),
    CHINAUMS_PAY("CHINAUMS_PAY","银联支付","CHINAUMS-QRCODE/CHINAUMS-MINI","CHINAUMS-SCAN",20),
    ICE_PAY("ICE_PAY","ICE支付","ICE-QRCODE","ICE-SCAN",22),
    GONGHANG_PAY("GONGHANG_PAY","工行支付","GONGHANG-QRCODE","",23),
    TONGCHENG_PAY("TONGCHENG_PAY","同程支付","TONGCHENG-QRCODE","",24),// 枚举值 24 已经被同程支付定义
    TONGLIAN_PAY("TONGLIAN_PAY","通联支付","TONGLIAN-QRCODE","",26),
    TJ_PAY("TJ_PAY","天津农商行聚合支付","TJ-QRCODE","TJ-SCAN",21),
    NINGBO_PAY("NINGBO_PAY","宁波支付","NINGBO-QRCODE/NINGBO-WX-MINI/NINGBO-ALI-MINI","NINGBO-SCAN",27),



    NO_SEN_PARKING_PAY("NO_SEN_PARKING_PAY","阿里平台无感支付","","",-1),
    NO_SEN_UNION_PAY("NO_SEN_UNION_PAY","银联无感支付","","",-1),
    NO_SEN_CCB_PAY("NO_SEN_CCB_PAY","建行无感支付","","",-1),
    NO_SEN_GANSU_PAY("NO_SEN_GANSU_PAY","甘肃银行无感支付","","",-1),
    NO_SEN_ZFB_PAY("NO_SEN_ZFB_PAY","支付宝无感支付","","",-1),
    NO_SEN_ICBC_PAY("NO_SEN_ICBC_PAY","工商银行无感支付","","",-1),

    @Deprecated
    NO_SEN_ABC_PAY("NO_SEN_ABC_PAY","农行无感支付","","",-1),

    @Deprecated
    CMBC_PAY("CMBC_PAY","民生银行聚合支付","QRCODE-QRCODE","",-1),

    @Deprecated
    PARKING_PAY("PARKING_PAY","阿里平台聚合支付","","",6),

    ;
    /**
     * 平台对应编码
     */
    private @Getter String code;
    /**
     * 描述
     */
    private @Getter String desc;
    /**
     * 正扫下单类型
     */
    private @Getter String tradeType;
    /**
     * 反扫下单类型
     */
    private @Getter String tradeTypeScan;
    /**
     * 支付渠道
     */
    private @Getter Integer  payAisle;

    public static PlatformPayType getByCode(String code){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                return payType;
            }
        }
        return null;
    }

    public static String getTradeType(String code,Integer payWay){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                if (payType.equals(NINGBO_PAY)){
                    if (PayMethodContants.ALIPAY_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[2];
                    }
                    if (PayMethodContants.WECHAT_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayWayContants.ALIPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                    if (PayWayContants.WECHAT.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                }
                if (payType.equals(WX_ALI_PAY)){
                    if (PayMethodContants.ALIPAY_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[3];
                    }
                    if (PayMethodContants.WECHAT_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[2];
                    }
                    if (PayWayContants.ALIPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayWayContants.WECHAT.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                }

                if (payType.equals(YZ_PAY) || payType.equals(LKL_PAY) || payType.equals(PP_PAY) || payType.equals(CHINAUMS_PAY)){
                    if (PayMethodContants.ALIPAY_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayMethodContants.WECHAT_APPLETS.equals(payWay)){
                        return payType.getTradeType().split("/")[1];
                    }
                    if (PayWayContants.ALIPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                    if (PayWayContants.WECHAT.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                    if (PayWayContants.UNIONPAY.equals(payWay)){
                        return payType.getTradeType().split("/")[0];
                    }
                }
                return payType.getTradeType();
            }
        }
        return null;
    }


    public static String getTradeTypeScan(String code,Integer payWay){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                if (payType.equals(WX_ALI_PAY)){
                    if (PayWayContants.ALIPAY.equals(payWay)){
                        return payType.getTradeTypeScan().split("/")[1];
                    }
                    if (PayWayContants.WECHAT.equals(payWay)){
                        return payType.getTradeTypeScan().split("/")[0];
                    }

                }
                return payType.getTradeTypeScan();
            }
        }
        return null;
    }

    public static Integer getPayAisle(String code,Integer payWay){
        for (PlatformPayType payType:PlatformPayType.values()){
            if (payType.getCode().equals(code)){
                if (payType.equals(WX_ALI_PAY)){
                    if (PayWayContants.WECHAT.equals(payWay)){
                        return PayAisleEnum.WX.getType();
                    }
                    if (PayWayContants.ALIPAY.equals(payWay)){
                        return PayAisleEnum.ALI.getType();
                    }
                }
                return payType.getPayAisle();
            }
        }
        return -1;
    }
}
