package com.icetech.paycenter.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.paycenter.domain.request.NotifyBaseRequest;
import com.icetech.paycenter.domain.request.PayCenterBaseRequest;
import com.icetech.paycenter.domain.response.icepay.IceParkPayConfig;

/**
 * 车场统一收单接口
 *
 * @author
 * @create 2020-07-11 17:54
 **/
public interface IParkPayConfigService {
    /**
     * 获取知位支付配置
     * @param parkCode
     * @return
     */
    ObjectResponse<IceParkPayConfig> getIcePayConfig(String parkCode);
    /**
     * 获取知位支付配置
     * @param parkId
     * @return
     */
    ObjectResponse<IceParkPayConfig> getIcePayConfig(Long parkId);

}
