package com.icetech.paycenter.domain.request.lkl;

import lombok.Data;

import java.io.Serializable;

/**
 * 拉卡拉进件请求
 * @author wangzhiwei
 */
@Data
public class InputSubmitReqModel implements Serializable {
    //--------------------公共信息------------------------
    /**
     * 车场id
     */
    private Long parkId;
    /**
     * 申请单号
     */
    private String orderNo;

    /**
     * 申请单类型 1=自然人 2=个体工商户对私 3=个体工商户对公 4=企业
     */
    private Integer applyType;
    /**
     * 是否法人收款 1=是 0=否
     */
    private Integer frAccount;

    //----------------------商户信息--------------------
    /**
     * 商户注册名称
     */
    private String merRegName;
    /**
     * 商户经营名称(简称) 为空时，同商户注册名称
     */
    private String merBizName;
    /**
     * 商户地区代码
     */
    private String merRegDistCode;
    /**
     * 商户省代码
     */
    private String merRegProvinceCode;
    /**
     * 商户城市代码
     */
    private String merRegCityCode;
    /**
     * 商户地址
     */
    private String merRegAddr;
    /**
     * 营业执照名称
     */
    private String merBlisName;
    /**
     * 营业执照号
     */
    private String merBlis;
    /**
     * 营业执照开始日期 yyyy-MM-dd
     */
    private String merBlisStDt;
    /**
     * 营业执照结束日期 yyyy-MM-dd
     */
    private String merBlisExpDt;
    /**
     * 	商户经营内容
     */
    private String merBusiContent;

    //----------------------法人或者自然人信息----------------------
    /**
     * 商户法人名称
     */
    private String larName;
    /**
     * 身份证	01
     * 护照	02
     * 港澳通行证	03
     * 台胞证	04
     * 其它证件	99
     */
    private String larIdType;
    /**
     * 法人身份证号码
     */
    private String larIdcard;
    /**
     * 法人身份证开始日期 yyyy-MM-dd
     */
    private String larIdcardStDt;
    /**
     * 法人身份结束效期 yyyy-MM-dd
     */
    private String larIdcardExpDt;


    //---------------------结算账户人信息(结算账户为法人时可为空)-------------------
    /**
     * 身份证 01 护照	02 港澳通行证	03 台胞证 04 其它证件	99
     */
    private String acctIdType;
    /**
     * 结算人证件号
     */
    private String acctIdcard;

    //---------------------账户信息-------------------
    /**
     * 结算账户开户行号
     */
    private String openningBankCode;
    /**
     * 结算账户开户行名称
     */
    private String openningBankName;
    /**
     * 结算账户清算行号
     */
    private String clearingBankCode;
    /**
     * 结算账户账号
     */
    private String acctNo;
    /**
     * 结算账户名称
     */
    private String acctName;
    /**
     * 结算账户类型 57 对公 58 对私
     */
    private String acctTypeCode;


    //--------------------商户联系人信息-----------------
    /**
     * 商户联系人手机号码
     */
    private String merContactMobile;
    /**
     * 商户联系人
     */
    private String merContactName;

    //--------------------合同信息-----------------
    /**
     * 合同编号
     */
    private String contractNo;

}
