package com.icetech.paycenter.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.paycenter.domain.BaseApplyBusinessRequest;
import com.icetech.paycenter.domain.request.lkl.ContractApplyReqModel;
import com.icetech.paycenter.domain.request.lkl.FileUploadReqModel;
import com.icetech.paycenter.domain.request.wx.WxApplySubmitRequest;
import com.icetech.paycenter.domain.response.common.BankInfoResponse;
import com.icetech.paycenter.domain.response.lkl.CarBinQueryResModel;
import com.icetech.paycenter.domain.response.lkl.ContractApplyResModel;
import com.icetech.paycenter.domain.response.lkl.FileUploadResModel;
import com.icetech.paycenter.domain.response.lkl.InputResModel;

import java.util.List;
import java.util.Map;

/**
 * @author kate
 */
public interface IMerchantInputService {

    /**
     * 商户进件主接口
     */
    ObjectResponse submitMerchantInput(BaseApplyBusinessRequest request);

    /**
     * 商户进件结果查询
     */
    ObjectResponse searchMerchantInput(BaseApplyBusinessRequest request);

    /**
     * 校验商户
     * @param request
     * @return
     */
    ObjectResponse<Boolean> checkMerchantInput(BaseApplyBusinessRequest request);

    /**
     * 微信图片上传接口
     */
    ObjectResponse<String> uploadFile(byte[] bytes,String filePath,String fileName);

    /**
     * 定时更新微信直连进件结果
     */
    ObjectResponse updateWxApply();

    /**
     * 定时更新间连进件结果
     */
    ObjectResponse updateYzApply();

    /**
     * 更新拉卡拉进件信息
     * @return
     */
    ObjectResponse updateLklApply();

    /**
     * 微信敏感字段消息加密处理
     */
    String rsaEncryptOAEP(String message);

    /**
     * 获取开户行名称
     */
    ObjectResponse getAccountBank(String accountBank);

    /**
     * 获取支行全称
     */
    ObjectResponse getBankName(String accountBank,String province,String city,String bankName);

    /**
     * 获取银行信息
     * @param accountBank
     * @return
     */
    ObjectResponse<List<BankInfoResponse>> getBankInfo(String accountBank,String bankCode);

    /**
     * 保存进件
     */
    ObjectResponse saveRegisterWx(WxApplySubmitRequest request);

    /**
     * 拉卡拉合同申请接口
     * @param model
     * @param parkId
     * @return
     */
    ObjectResponse<ContractApplyResModel> contractApply4Lkl(ContractApplyReqModel model);

    /**
     * 电子合同下载
     * @param orderNo 申请编号
     * @return
     */
    ObjectResponse<Map<String,String>> contractDownload4Lkl(String orderNo);

    /**
     * 合同查询
     * @param orderNo
     * @return
     */
    ObjectResponse<String> contractQuery4Lkl(String orderNo);

    /**
     * 拉卡拉附件上传接口
     * @param model
     * @param parkId
     * @return
     */
    ObjectResponse<FileUploadResModel> uploadFile4Lkl(byte[] bytes, String orderNo, Integer fileType, String fileName);

    /**
     * 获取申请编号
     * @param parkId
     * @return
     */
    ObjectResponse<String> getApplyNo(Long parkId);

    /**
     * 银行卡信息查询
     * @param bankCarNo 银行卡账号
     * @return
     */
    ObjectResponse<CarBinQueryResModel> queryCarBin(String orderNo,String bankCarNo);

}
