package com.icetech.paycenter.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.paycenter.domain.request.PayCenterBaseRequest;

/**
 * 支付中心 授权 接口
 * @author wangzw
 */
public interface IAuthorizationService {


    /**
     * 获取授权请求地址
     * @param parkCode
     * @return
     */
    ObjectResponse<String> getAuthLink4Wx(String parkCode,String redirectUrl);
    ObjectResponse<String> getAuthLink4Wx(String parkCode);
    ObjectResponse<String>  getRedpackAuthLink4Wx(String parkCode, Integer redpackModel, String redirectUrl);
    @Deprecated
    ObjectResponse<String>  getYzAuthLink4Wx(String redirectUrl);


    /**
     * 获取授权请求地址
     * @param parkCode
     * @return
     */
    ObjectResponse<String> getAuthLink4Ali(String parkCode,String redirectUrl);
    ObjectResponse<String> getAuthLink4Ali(String parkCode);

    /**
     * 获取微信openid
     * @param wxCode 微信授权码
     * @param parkCode 车场编号
     * @return
     */
    ObjectResponse<String> getWxOpenId(String wxCode,String parkCode);

    /**
     * 获取支付宝userId
     * @param aliCode 支付宝授权码
     * @param parkCode 车场编号
     * @return
     */
    ObjectResponse<String> getAliUserId(String aliCode,String parkCode);

    /**
     * 验证签名
     * @param baseRequest
     * @return
     */
    Boolean verifySign(PayCenterBaseRequest baseRequest);

    /**
     * pid 获取签名key
     * @param pid
     * @return
     */
    ObjectResponse<String> getSecurityByPid(String pid);

    /**
     * 获取建设银行的 pubKey
     * @param parkCode
     * @return
     */
    ObjectResponse<String> getCcbPubKey(String parkCode);
}
