/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.partner.domain.piaotong;

import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.time.DateFormatUtils;

public class PiaoTongRequest {
    protected String platformCode;
    protected final String signType = "RSA";
    protected String sign;
    protected final String format = "JSON";
    protected String timestamp;
    protected final String version = "1.0";
    protected String serialNo;
    protected String content;

    public static String getSignContent(PiaoTongRequest request) {
        return "content=" + request.getContent() + "&format=" + request.getFormat() + "&platformCode=" + request.getPlatformCode() + "&serialNo=" + request.getSerialNo() + "&signType=" + request.getSignType() + "&timestamp=" + request.getTimestamp() + "&version=" + request.getVersion();
    }

    public static PiaoTongRequest getInstance(String platformCode, String platformAlias) {
        PiaoTongRequest request = new PiaoTongRequest();
        request.setPlatformCode(platformCode);
        Date now = new Date();
        request.setTimestamp(DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss"));
        Random random = new Random(System.currentTimeMillis());
        StringBuilder builder = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            builder.append(random.nextInt(10));
        }
        String serialNo = platformAlias + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + builder;
        request.setSerialNo(serialNo);
        return request;
    }

    public String getPlatformCode() {
        return this.platformCode;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getSign() {
        return this.sign;
    }

    public String getFormat() {
        return this.format;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public String getContent() {
        return this.content;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PiaoTongRequest)) {
            return false;
        }
        PiaoTongRequest other = (PiaoTongRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$platformCode = this.getPlatformCode();
        String other$platformCode = other.getPlatformCode();
        if (this$platformCode == null ? other$platformCode != null : !this$platformCode.equals(other$platformCode)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$serialNo = this.getSerialNo();
        String other$serialNo = other.getSerialNo();
        if (this$serialNo == null ? other$serialNo != null : !this$serialNo.equals(other$serialNo)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PiaoTongRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $platformCode = this.getPlatformCode();
        result = result * 59 + ($platformCode == null ? 43 : $platformCode.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $serialNo = this.getSerialNo();
        result = result * 59 + ($serialNo == null ? 43 : $serialNo.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "PiaoTongRequest(platformCode=" + this.getPlatformCode() + ", signType=" + this.getSignType() + ", sign=" + this.getSign() + ", format=" + this.getFormat() + ", timestamp=" + this.getTimestamp() + ", version=" + this.getVersion() + ", serialNo=" + this.getSerialNo() + ", content=" + this.getContent() + ")";
    }
}

