package com.icetech.partner.domain.response.wx;

import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.List;

/**
 * 微信签约返回
 * @author kate
 */
@Data
public class WxQueryResponse implements Serializable{
    /**
     * 业务申请编号
     */
    private String business_code;
    /**
     * 微信支付申请单号
     */
    private String applyment_id;
    /**
     * 特约商户号
     */
    private String sub_mchid;
    /**
     * 超级管理员授权链接
     */
    private String sign_url;
    /**
     * <pre>
     *  1、APPLYMENT_STATE_EDITTING（编辑中）：提交申请发生错误导致，请尝试重新提交。
     *  2、APPLYMENT_STATE_AUDITING（审核中）：申请单正在审核中，超级管理员用微信打开“签约链接”，完成绑定微信号后，申请单进度将通过微信公众号通知超级管理员，引导完成后续步骤。
     *  3、APPLYMENT_STATE_REJECTED（已驳回）：请按照驳回原因修改申请资料，超级管理员用微信打开“签约链接”，完成绑定微信号，后续申请单进度将通过微信公众号通知超级管理员。
     *  4、APPLYMENT_STATE_TO_BE_CONFIRMED（待账户验证）：请超级管理员使用微信打开返回的“签约链接”，根据页面指引完成账户验证。
     *  5、APPLYMENT_STATE_TO_BE_SIGNED（待签约）：请超级管理员使用微信打开返回的“签约链接”，根据页面指引完成签约。
     *  6、APPLYMENT_STATE_SIGNING（开通权限中）：系统开通相关权限中，请耐心等待。
     *  7、APPLYMENT_STATE_FINISHED（已完成）：商户入驻申请已完成。
     *  8、APPLYMENT_STATE_CANCELED（已作废）：申请单已被撤销。
     * </pre>
     * 申请单状态
     */
    private String applyment_state;
    /**
     * 驳回原因详情 各项资料的审核情况，当申请状态为APPLYMENT_STATE_REJECTED时才返回
     */
    private List<WxAuditDetail> audit_detail;


    public enum ApplymentState{
        APPLYMENT_STATE_EDITTING("APPLYMENT_STATE_EDITTING","编辑中"),
        APPLYMENT_STATE_AUDITING("APPLYMENT_STATE_AUDITING","审核中"),
        APPLYMENT_STATE_REJECTED("APPLYMENT_STATE_REJECTED","已驳回"),
        APPLYMENT_STATE_TO_BE_CONFIRMED("APPLYMENT_STATE_TO_BE_CONFIRMED","待账户验证"),
        APPLYMENT_STATE_TO_BE_SIGNED("APPLYMENT_STATE_TO_BE_SIGNED","待签约"),
        APPLYMENT_STATE_SIGNING("APPLYMENT_STATE_SIGNING","开通权限中"),
        APPLYMENT_STATE_FINISHED("APPLYMENT_STATE_FINISHED","已完成"),
        APPLYMENT_STATE_CANCELED("APPLYMENT_STATE_CANCELED","被撤销"),
        ;
        private @Getter String status;
        private @Getter String desc;
        ApplymentState(String status,String desc){
            this.desc = desc;
            this.status = status;
        }

    }

}
