package com.icetech.partner.domain.response.tingjiandan;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

@Data
@Builder
public class GetInParkOrderInfoRes implements Serializable {
    /**
     * 响应时间
     */
    private String timestamp;

    /**
     * 响应码
     */
    private String returnCode;

    /**
     * 响应描述
     */
    private String returnMsg;

    /**
     * 请求是否成功
     */
    private String isSuccess;

    /**
     * 错误信息
     */
    private String errorMSG;

    /**
     * 停车订单号
     */
    private String tradeId;

    /**
     * 停车时长 单位(秒)
     */
    private String parkTime;

    /**
     * 进场时间 格式：yyyyMMddHHmmss
     */
    private String inDt;

    /**
     * 计费截止时间 格式：yyyyMMddHHmmss
     */
    private String outDt;

    /**
     * 免费出场时间 单位(分钟)
     */
    private String freeThroughTime;

    /**
     * 停车总金额 单位(元)，保留小数点后两位
     */
    private String totalAmount;

    /**
     * 还需支付金额 单位(元)，保留小数点后两位
     */
    private String unPayAmount;

    /**
     * 已经支付费用 单位(元)，保留小数点后两位
     */
    private String paidAmount;

    /**
     * 车牌号
     */
    private String carNum;

    /**
     * 支付URL
     */
    private String payUrl;

    /**
     * 小程序参数集 小程序支付参数集（json字符串）
     */
    private String miniProgram;

    /**
     * 停车场位置经度 百度坐标系
     */
    private String lon;

    /**
     * 停车场位置纬度 百度坐标系
     */
    private String lat;

    /**
     * 停车场位置经度 wgs84坐标系
     */
    private String wLon;

    /**
     * 停车场位置纬度 wgs84坐标系
     */
    private String wLat;

    /**
     * 客服电话
     */
    private String customerServicePhone;

    /**
     * 服务费总额
     */
    private String serverFeeTotalAmount;

    /**
     * 服务费已支付金额
     */
    private String serverFeePaidAmount;

    /**
     * 服务费待支付金额
     */
    private String serverFeeUnPayAmount;

}
