package com.icetech.partner.domain.response;


import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/14 16:38
 * @description:
 */
@Data
public class MonthCardProductResponse  implements Serializable {

    /**
     * 月卡产品编号(为空是则创建新的月卡产品)
     */
    private String productId;
    /**
     * 月卡产品名称
     */

    private String productName;

    /**
     * 产品面额（X月）
     */

    private String duration;
    /**
     * 销售金额（元）
     */

    private String payMoney;
    /**
     * 月卡产品类型（1全天2分时段）
     */

    private String cardType;

    /**
     * 可用开始时间2018-10-31
     */

    private String startDate;
    /**
     * 可用结束时间2018-10-31
     */

    private String endDate;
    /**
     * 开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）
     */
    private String startTime;
    /**
     * 结束时间点（跨天开始>结束，例如09:00:00）
     */
    private String endTime;
    /**
     * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 
     */

    private Integer buyWay;
}
