package com.icetech.partner.domain.request.wuxi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Date;
import java.util.List;

/**
 * @author FGD
 */
@Data
public class WuXiRequest {
    /**
     * 平台编号(platformNo)
     */
    protected String pno;
    /**
     * 令牌(token)
     */
    protected String tn;
    /**
     * 请求时间(yyyyMMddHHmmssSSS)
     */
    protected String ts;
    /**
     * 版本号(version),可为空，默认1.0
     */
    protected String ve;
    /**
     * 业务参数(有转义符)，JSON格式字符串，通过AES对称加密(仅业务参数需要进行加密),
     */
    protected String dataItems;
    protected String file;

    public static final String TS_DATE_PATTERN = "yyyyMMddHHmmssSSS";

    public WuXiRequest(String pno, String tn, BaseDataItem dataItem, String file) {
        this.pno = pno;
        this.tn = tn;
        this.ts = DateFormatUtils.format(new Date(), TS_DATE_PATTERN);
        this.dataItems = JSONObject.toJSONString(dataItem);
        this.file = file;
    }

    public WuXiRequest(String pno, String tn, List<BaseDataItem> dataItems) {
        this.pno = pno;
        this.tn = tn;
        this.ts = DateFormatUtils.format(new Date(), TS_DATE_PATTERN);
        this.dataItems = JSONArray.toJSONString(dataItems);
    }
}
