package com.icetech.partner.domain.request.tingjiandan;

import com.alibaba.fastjson2.annotation.JSONField;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TingJianDanRequest {
    /**
     * 公共参数：AppId 是
     */
    @com.alibaba.fastjson.annotation.JSONField(name = "AppId")
    @JSONField(name = "AppId")
    @NotEmpty(message = "AppId不能为空")
    protected String appId;

    /**
     * 公共参数：当前时间戳/秒 是
     */
    @NotNull(message = "当前时间戳不能为空")
    protected Long ts;

    /**
     * 公共参数：随机正整数 是
     */
    @com.alibaba.fastjson.annotation.JSONField(name = "Nonce")
    @JSONField(name = "Nonce")
    @NotNull(message = "随机正整数不能为空")
    protected Integer nonce;
}
