package com.icetech.partner.domain.request.shanghai;

import lombok.Data;

import java.io.Serializable;

@Data
public class ShExitRequest implements Serializable {
    /**
     *交易序列号，需唯一，最大长度32 位
     * 必填
     */
    private String seq;
    /**
     *车牌号
     * 必填
     */
    private String plateId;
    /**
     *车型
     * 1-大型
     * 2-中型
     * 3-小型
     * 9-其它
     * 必填
     */
    private Integer vehicleType;
    /**
     *1-人工
     * 2-自动（ETC、无感等） 9-其它
     * 必填
     */
    private Integer laneType = 9;
    /**
     *空余车位数
     * 必填
     */
    private Integer freeBerth;
    /**
     *停车类型
     * 1-临停
     * 2-包月
     * 9-其它
     */
    private Integer parkType;
    /**
     * 停车时长（单位：秒）
     */
    private Integer parkingTime;
    /**
     * 付款金额（单位：分）
     */
    private Integer payMoney;
    /**
     * wechat：微信
     * alipay：支付宝
     * uppay：银联
     * cash：现金
     * tcard：公交卡
     * unknown：其它
     */
    private String payType;
    /**
     *入场时间： UTC时间戳，从1970年1 月1日0点0分0秒开始到现在的毫秒数,例如：1420123421000
     */
    private Long dataTime;
    /**
     *签名结果
     */
    private String sign;

}
