package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author zhangpengzhan
 * @date 2021/1/14 15:01
 */
@Data
public class RenewMonthCardOpenRequest implements Serializable {
    /**
     * 车场编号
     */
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "1P1594692385", position = 1)
    private String parkCode;
    
    /**
     * 月卡产品id
     */
    @NotNull(message = "月卡套餐编号不能为空")
    @ApiModelProperty(value = "月卡套餐编号", required = true, example = "1", position = 2)
    private Long productId;
    
    /**
     * 月卡id
     */
    @NotNull(message = "月卡编号不能为空")
    @ApiModelProperty(value = "月卡编号", required = true, example = "1", position = 3)
    private Long cardId;
    
    /**
     * 车位数量，默认为1，可支持多车位多车
     */
    @NotNull(message = "车位数量不能为空")
    @ApiModelProperty(value = "车位数量，默认为1，可支持多车位多车", required = true, example = "10", position = 4)
    private Integer plotCount;
    
    /**
     * 月卡有效开始日期，格式为年-月-日
     */
    @NotBlank(message = "月卡有效开始日期不能为空")
    @ApiModelProperty(value = "月卡有效开始日期，格式为年-月-日", required = true, example = "2022-07-07", position = 5)
    private String startTime;
    
    /**
     * 月卡有效结束日期，格式为年-月-日
     */
    @NotBlank(message = "月卡有效开始日期不能为空")
    @ApiModelProperty(value = "月卡有效开始日期，格式为年-月-日", required = true, example = "2022-07-31", position = 6)
    private String endTime;

    /**
     * 月卡范围 1=全车场 2=指定区域
     */
    @ApiModelProperty(value = "月卡范围 1=全车场 2=指定区域", example = "1", position = 7)
    private Integer mcRange;

    @ApiModelProperty(value = "月卡区域分区编号，mcRange=2时需指定办理的月卡的分区，分区编号从车场分区列表接口中获取", example = "1", position = 8)
    private List<RegionData> regionData;

    @Data
    public static class RegionData implements Serializable {

        @ApiModelProperty(value = "区域编号", example = "1", position = 1)
        private String regionCode;
    }
}
