package com.icetech.partner.domain.request.open;

import lombok.Data;

import java.io.Serializable;

/**
 * 海淀车场静态数据上报
 */
@Data
public class QianFangParkRequest implements Serializable {

    /**
     * 停车场编号(自定义生成)
     * 生成规则：停车场所在区域 邮政编码(6位)+停车场统一 编码(8 位)+设备商编码(4 位)+停车场序号(4 位)
     */
    private String parkingNo;
    /**
     * 停车场统一编号(接口提供方索要)
     */
    private String parkingUniNo;
    /**
     * 停车场名称
     */
    private String parkingName;
    /**
     * 停车场位置
     */
    private String address;
    /**
     * 经营单位
     */
    private String operatingUnit;
    /**
     * 停车场性质
     */
    private Integer parkingProp;
    /**
     * 停车场类型 0：未知 1：路侧占道 2：（已废弃） 3：路外公共 4：公建配建 5：单位大院 6：居住小区 7：驻车换乘 8：其他 9：立交桥下
     */
    private Integer parkingType;
    /**
     * 停车位数量
     */
    private Integer parkingNum;
}
