package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Setter
@Getter
@ToString
public class ParkFreeSpaceRequest implements Serializable {
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

}
