package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class PageRequest implements Serializable {
    /**
     * 页码
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "页码不能为空")
    @ApiModelProperty(value = "页码", required = true, example = "1", position = 1)
    private Integer pageNo;
    /**
     * 分行业大小
     */
    @javax.validation.constraints.NotNull(message = "分页大小不能为空")
    @ApiModelProperty(value = "分页大小", required = true, example = "10", position = 2)
    private Integer pageSize;
}
