package com.icetech.partner.domain.request.open;

import lombok.Data;

import java.io.Serializable;

/**
 * 海淀车场出入场上报
 */
@Data
public class JinDiParkExitRequest implements Serializable {
    private int id;
    private int enter_id;
    private String enter_url;
    private String enter_time;
    private String lot_id;
    private String leave_time;
    private String leave_url;
    private float payable_amount;
    private float paid_amount;
    private int pay_method = 10;
    private float refund_amount;
    private int exception_code;
    private String note;
    private String car_num;
    private int car_type;
    private String car_brand;
    private String car_color;
    private int car_num_type;
    private String car_num_color;
    /**
     * 平台支付方式与金地支付方式转换
     * @param type
     * @return
     */
    public static Integer convertLocalPayMethod(Integer type){
        if (type == 1){
            //现金
            return 9;
        }
        if (type == 2){
            //微信
            return 2;
        }
        if (type == 3){
            //支付宝
            return 5;
        }
        return 10;
    }

    /**
     * 平台车辆类型金地车辆类型转换
     * @param type
     * @return
     */
    public static Integer convertLocalCarType(Integer type){
        if (type == 1){
            //普通车
            return 3;
        }
        if (type == 2){
            //长租车
            return 1;
        }
        if (type == 3){
            //特殊车辆
            return 2;
        }
        if (type == 4){
            //vip
            return 4;
        }
        return 3;
    }
}
