package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 2.10.入场通知接口
 */
@Setter
@Getter
@ToString
public class EnterSyncRequest implements Serializable {
    /**
     * 车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;
    /**
     * 通道编号
     */
    @NotNull
    @NotBlank(message = "通道编号不能为空")
    @ApiModelProperty(value = "通道编号", required = true, example = "C000001", position = 2)
    private String channelCode;
    /**
     * 车牌号
     */
    @NotNull
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号", required = true, example = "C000001", position = 3)
    private String plateNum;
    /**
     * 入场时间，UNIX时间戳
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "入场时间不能为空")
    @ApiModelProperty(value = "入场时间", required = true, example = "1623343433000", position = 4)
    private Long enterTime;

    /**
     * 三方订单号
     */
    private String orderNum;
}
