package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 编辑临时车收费规则参数
 * @author zhangpengzhan
 * @date 2021/1/7 11:18
 */
@Data
public class EditChargeRuleRequest implements Serializable {
    /**
     * 云平台停车场编码
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    /**
     * 规则Id
     */
    @ApiModelProperty(value = "平台计费规则编码",  example = "111", position = 2)
    private String ruleId;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称",  example = "规则13", position = 3)
    private String ruleName;

    /**
     * 免费停车时间 timeOne分钟
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "timeFour不能为空")
    @ApiModelProperty(value = "免费停车时间 timeOne分钟", required = true, example = "10", position = 4)
    private Integer timeOne;

    /**
     * 前timeTwo分钟收费chargeThree元
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "timeFour不能为空")
    @ApiModelProperty(value = "前timeTwo分钟收费chargeThree元", required = true, example = "10", position = 5)
    private Integer timeTwo;

    /**
     * 前timeTwo分钟收费chargeThree元
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "timeFour不能为空")
    @ApiModelProperty(value = "前timeTwo分钟收费chargeThree元", required = true, example = "10", position = 6)
    private Integer chargeThree;

    /**
     * 之后每timeFour分钟收费chargeFive元
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "timeFour不能为空")
    @ApiModelProperty(value = "之后每timeFour分钟收费chargeFive元", required = true, example = "10", position = 7)
    private Integer timeFour;

    /**
     * 之后每timeFour分钟收费chargeFive元
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "chargeSeven不能为空")
    @ApiModelProperty(value = "之后每timeFour分钟收费chargeFive元", required = true, example = "10", position = 8)
    private Integer chargeFive;

    /**
     * 到timeSix时间的封顶价格chargeSeven 元（如果chargeSeven=-1，代表无封顶价格）
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "chargeSeven不能为空")
    @ApiModelProperty(value = "到timeSix时间的封顶价格chargeSeven 元（如果chargeSeven=-1，代表无封顶价格）", required = true, example = "10", position = 9)
    private Integer timeSix;

    /**
     * 到timeSix时间的封顶价格chargeSeven 元（如果chargeSeven=-1，代表无封顶价格）
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "chargeSeven不能为空")
    @ApiModelProperty(value = "到timeSix时间的封顶价格chargeSeven 元（如果chargeSeven=-1，代表无封顶价格）", required = true, example = "10", position = 10)
    private Integer chargeSeven;

    /**
     * 支持24小时多次进入最高收费价格chargeEight，按本次出场时间往前24小时之内的进场缴费总和。如果chargeEight为0，代表不支持24小时多次进入最高收费
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "chargeEight不能为空")
    @ApiModelProperty(value = "支持24小时多次进入最高收费价格chargeEight，按本次出场时间往前24小时之内的进场缴费总和。如果chargeEight为0，代表不支持24小时多次进入最高收费", required = true, example = "10", position = 11)
    private Integer chargeEight;
}
