package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 编辑通道权限接口
 * @author zhangpengzhan
 * @date 2021/1/12 9:56
 */
@Data
public class EditChannelRuleRequest implements Serializable {
    /**
     * 停车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    /**
     * 通道配置编号
     */
    @NotNull
    @NotBlank(message = "通道配置编号不能为空")
    @ApiModelProperty(value = "通道配置编号", required = true, example = "C100000", position = 2)
    private String channelId;

    /**
     * 是否允许临时车进出 0:不允许  1：允许 默认1
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否允许临时车进出不能为空")
    @ApiModelProperty(value = "是否允许临时车进出 0:不允许 1：允许 默认1", required = true, example = "1", position = 3)
    private Integer isAllowTempCarrun;

    /**
     * 是否允许蓝牌车进出 0:不允许  1：允许 默认1
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "否允许蓝牌车进出不能为空")
    @ApiModelProperty(value = "是否允许蓝牌车进出 0:不允许 1：允许 默认1", required = true, example = "1", position = 4)
    private Integer isAllowBluerun;

    /**
     * 是否允许无牌车扫码进出 0:不允许  1：允许 默认1
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否允许无牌车扫码进出不能为空")
    @ApiModelProperty(value = "是否允许无牌车扫码进出 0:不允许 1：允许 默认1", required = true, example = "1", position = 5)
    private Integer isAllowNocardrun;

    /**
     * 黄牌车是否允许进 0:不开启  1：开启 默认0
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "黄牌车是否允许进不能为空")
    @ApiModelProperty(value = "黄牌车是否允许进 0:不开启 1：开启 默认0", required = true, example = "1", position = 6)
    private Integer isAllowYellowCarrun;

    /**
     * 是否开启模糊识别 0:不开启  1：开启 默认0
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否开启模糊识别不能为空")
    @ApiModelProperty(value = "是否开启模糊识别 0:不开启 1：开启 默认0", required = true, example = "1", position = 7)
    private Integer isOpenVaguetype;

    /**
     * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
     */
    @javax.validation.constraints.NotNull(message = "模糊模式不能为空")
    @ApiModelProperty(value = "模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位", required = true, example = "1", position = 8)
    private Integer vaguetype;

    /**
     * 是否允许新能源车辆进出 0：不允许 1：允许 默认1
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否允许新能源车辆进出不能为空")
    @ApiModelProperty(value = "是否允许新能源车辆进出 0：不允许 1：允许 默认1", required = true, example = "1", position = 9)
    private Integer isAllowNewenergyCarrun;

    /**
     * 是否允许预约车进出0：不允许，1：允许
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否允许预约车进出不能为空")
    @ApiModelProperty(value = "是否允许预约车进出0：不允许，1：允许", required = true, example = "1", position = 10)
    private Integer isAllowVisitCar;

    /**
     * 是否允月卡车车进出0：不允许，1：允许
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否允月卡车车进出不能为空")
    @ApiModelProperty(value = "是否允月卡车车进出0：不允许，1：允许", required = true, example = "1", position = 11)
    private Integer isAllowMonthCar;

    /**
     * 是否允许多位多车月卡车进出1=是 0=否
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "是否允许多位多车月卡车进出不能为空")
    @ApiModelProperty(value = "是否允许多位多车月卡车进出1=是 0=否", required = true, example = "1", position = 12)
    private Integer isAllowAbcar;

    /**
     * 是否允许储值卡车进出 0:不允许  1：允许 默认1
     */
    @ApiModelProperty(value = "是否允许储值卡车进出 0:不允许  1：允许 默认1", example = "1", position = 13)
    private Integer isAllowStoredCar;
    
    /**
     * 是否允许黑名单车进出1=是 0=否
     */
    @ApiModelProperty(value = "是否允许黑名单车进出1=是 0=否", example = "1", position = 14)
    private Integer isAllowBackCar;
}
