package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 删除月卡产品
 * @author zhangpengzhan
 * @date 2021/1/14 16:45
 */
@Data
public class DelMonthProductRequest implements Serializable {
    /**
     * 停车场编号
     */
    @NotNull
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "P100001", position = 1)
    private String parkCode;
    
    /**
     * 月卡套餐id集合
     */
    @ApiModelProperty(value = "需要删除的月卡套餐的编号集合", example = "1,3,4", position = 1)
    private List<String> productId;
}
