package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wanggang
 * @create 2023-10-26 11:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AdvertFeeRequest implements Serializable {

    /**
     * 广告类型
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "类型不能为空")
    @ApiModelProperty(value = "广告类型:1安泊;2腾讯", required = true, example = "1", position = 1)
    private Integer type;

    /**
     * 收益金额:元
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "类型不能为空")
    @ApiModelProperty(value = "收益金额:元", required = true, example = "100.00", position = 2)
    private BigDecimal amount;

    /**
     * 统计日期:yyyymmdd
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "统计日期为空")
    @ApiModelProperty(value = "收益金额:元", required = true, example = "20230606", position = 3)
    private Long reportDate;
}
