package com.icetech.partner.domain.request.lanzhou;

import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class LanZhouExitRequest {
    /**
     * 车牌号
     */
    private String plateNo;
    /**
     *电子牌识别结果与RFID结果一致，如甘A12345
     */
    private String plateParseInfo;
    /**
     *车辆类型
     */
    private String vehicleType;
    /**
     * 进口编号
     */
    private String entryId;
    /**
     * 出口编号
     */
    private String exitId;

    /**
     * 进场时间 毫秒
     */
    private Long entryTime;
    /**
     * 出场时间 毫秒
     */
    private Long exitTime;
    /**
     * 进场图片
     */
    private String entryPhoto;
    /**
     * 出场图片
     */
    private String exitPhoto;
    /**
     * 交易时间
     */
    private Long tradeTime;
    /**
     * 费用
     */
    private String accounts;
    /**
     * 现场收取现金
     */
    private Double cash;
    /**
     * 收费员
     */
    private String tollCollectorName;

    @Override
    public String toString() {
        return "LanZhouExitRequest{" +
                "plateNo='" + plateNo + '\'' +
                ", plateParseInfo='" + plateParseInfo + '\'' +
                ", vehicleType='" + vehicleType + '\'' +
                ", entryId='" + entryId + '\'' +
                ", exitId='" + exitId + '\'' +
                ", entryTime=" + entryTime +
                ", exitTime=" + exitTime +
                ", entryPhoto='" + "" + '\'' +
                ", exitPhoto='" + "" + '\'' +
                ", tradeTime=" + tradeTime +
                ", accounts='" + accounts + '\'' +
                ", cash=" + cash +
                ", tollCollectorName='" + tollCollectorName + '\'' +
                '}';
    }
}
