package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 杭州城市大脑 上传照片
 *
 * @author zhangpengzhan
 * @date 2020/8/16 10:27
 */
@Setter
@Getter
@ToString
public class UploadPhoto implements Serializable {

    /**
     * 照片对应车辆到达记录
     * 的流水号，参见“上传
     * 车辆到达记录
     * （UploadCarInData）”
     */
    @NotNull
    private String uid;

    /**
     * 该编号在场库系统中保
     * 证唯一
     */
    @NotNull
    private String parkingCode;

    /**
     * 场库系统给出的照片编
     * 号
     */
    @NotNull
    private String photoID;

    /**
     * 照片生成时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String time;

    /**
     * 到达或离开的照片，参
     * 见数据字典
     */
    @NotNull
    private Integer type;

    /**
     * 照片文件名
     */
    @NotNull
    private String name;

    /**
     * Base64 编码字符串
     * （注：大小不超过
     * 512K）；
     * 不参与加密签名，单独
     * key-value 传输
     */
/*    @NotNull
    private String file;*/

    /**
     * 上传时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;

}
