package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 杭州城市大脑 上传停车场剩余开放泊位数
 *
 * @author zhangpengzhan
 * @date 2020/8/16 10:26
 */
@Getter
@Setter
@ToString
public class UploadParkingState implements Serializable {

    /**
     * 停车场编号
     */
    @NotNull
    private String parkingCode;

    /**
     * 泊位总数
     */
    @NotNull
    private Integer totalBerthNum;

    /**
     * 开放泊位数
     */
    @NotNull
    private Integer openBerthNum;

    /**
     * 剩余开放泊
     * 位数，参见
     * 名词解释
     */
    @NotNull
    private Integer freeBerthNum;

    /**
     * 上传时间
     * （格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;
}
