package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 停车记录流水号下载
 *
 * @author zhangpengzhan
 * @date 2020/8/18 9:51
 */
@Setter
@Getter
@ToString
public class DownUIDRequest {
    /**
     *停车场编号
     * 该编号在场库系
     * 统中保证唯一
     */
    private String parkingCode;

    /**
     * 对账日期(格式：
     * yyyy-MM-dd)
     */
    @NotNull
    private String accountDate;

    /**
     * 进、出及账单标
     * 志（0-进；1-出； 2-账单；3-图片）
     */
    @NotNull
    private Integer type;

    /**
     * 上传时间（格
     * 式：yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;
}
