package com.icetech.partner.domain.request.haida;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-05-28 13:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class HaiDaPyaRecordDTO implements Serializable {

    /**
     * 停车场账单编号
     */
    private String billID;

    /**
     * 流水号一次车辆入场的流水号（场库编号+ 入口编号+ 时间戳（yyyy MMdd HHmmsssss ）保障唯一，不重复
     */
    private String uid;

    /**
     * 车牌号:
     * 必须为正确的车牌格式，不带空格或- 等特殊符号，
     * 对于无车牌车 统一传‘‘无车牌’’三个字，
     * 未识别车牌的统一传‘‘未识别’’
     */
    private String plateNo;

    /**
     * 停车场编号:
     * 该编号在场库系统中保证唯一
     */
    private String parkingCode;

    /**
     * 计费金额(单位:分)
     */
    private Integer chargeFee;

    /**
     * 应收金额(单位:分)
     */
    private Integer shouldPay;

    /**
     * 交易金额
     */
    private Integer actualPay;

    /**
     * 账单生成时间:
     * 格式:yyyy-MM-dd HH:mm:ss
     */
    private String billTime;

    /**
     * 交易时间:
     * 格式:yyyy-MM-dd HH:mm:ss
     */
    private String dealTime;

    /**
     * 付费方式
     * 1:现金; 2:支付宝; 3:微信; 4:平台账户; 5:市民卡钱包; 6:银联; 7:工行瞬付; 8:建行龙支付; 9:招行; 10:ETC
     */
    private Integer paidType;

    /**
     * 付费场景
     * 101:先离场后付费; 102:场内提前付费; 103:出入口付费; 104:欠费补缴
     */
    private Integer payType;

    /**
     * 上传时间
     * 格式:yyyy-MM-dd HH:mm:ss
     */
    private String uploadTime;

    /**
     * 是否通过全市一个停车场付费
     * 1-是
     * 0-否
     */
    private Integer billWay;
}
