package com.icetech.partner.domain.request.haida;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-05-28 13:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class HaiDaEnterDTO implements Serializable {

    /**
     * 流水号一次车辆入场的流水号（场库编号+ 入口编号+ 时间戳（yyyy MMdd HHmmsssss ）保障唯一，不重复
     */
    private String uid;

    /**
     * 入场记录id
     */
    private String arriveID;

    /**
     * 车牌号:
     * 必须为正确的车牌格式，不带空格或- 等特殊符号，
     * 对于无车牌车 统一传‘‘无车牌’’三个字，
     * 未识别车牌的统一传‘‘未识别’’
     */
    private String plateNo;

    /**
     * 车型:
     * 1:小型车;2:中型车;3:大型车
     */
    private Integer carType;

    /**
     * 停车场编号:
     * 该编号在场库系统中保证唯一
     */
    private String parkingCode;

    /**
     * 岗亭编号
     */
    private String gateNo;

    /**
     * 入口编号
     */
    private String entryNum;

    /**
     * 收费员编号
     */
    private String operatorCode;

    /**
     * 泊位总数
     */
    private Integer totalBerthNum;

    /**
     * 开放泊位数
     */
    private Integer openBerthNum;

    /**
     * 剩余开放泊位数
     */
    private Integer freeBerthNum;

    /**
     * 入场时间
     * 格式:yyyy-MM-dd HH:mm:ss
     */
    private String arriveTime;

    /**
     * 停车类型
     * 1:临时停车; 2:包月停车; 3:共享停车; 4:特殊停车
     */
    private Integer parkingType;

    /**
     * 车牌颜色:
     * 1:蓝色; 2:黄色; 3:白色; 4:黑色; 5:绿色; 6:黄绿
     */
    private Integer plateColor;

    /**
     * 上传时间
     * 格式:yyyy-MM-dd HH:mm:ss
     */
    private String uploadTime;
}
