package com.icetech.partner.domain.request.dongcheng;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-02-28 14:28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BeiJingDongChengExitRequest implements Serializable {

    /**
     * 订单编号
     */
    public String orderSn;

    /**
     * 停车场编号
     */
    public String parkSn;

    /**
     * 入场记录编号
     */
    public String intoRecordSn;

    /**
     * 出场记录编号
     */
    private String outRecordSn;

    /**
     * 车牌号
     */
    public String licencePlate;

    /**
     * 车牌颜色 蓝：0；黄：1；绿：2；黄
     * 绿：3；黑：4，白：5；其
     * 他：6
     */
    public String carColor;

    /**
     * 进场时间
     */
    public String inTime;

    /**
     * 进场时间
     */
    public String outTime;

    /**
     * 停车时长(秒)
     */
    public Integer longTime;

    /**
     * 接收时间
     */
    public String acceptTime;

    /**
     * 发送时间
     */
    public String sendTime;

    /**
     * 缴费类型 临停:0;包月:1;免费（白名单）:2
     */
    public Integer payType;

    /**
     * 缴费方式: 微信 :0; 支付宝 :1; 聚
     * 合:2;ETC:3;现金:4;畅行
     * 车:5;包月:6;免费（白名
     * 单）:7;异常:8;多种支付
     * 方式使用英文逗号分
     * 隔，如支付方式为微信
     * 和支付宝时，该字段值
     * 为0,1;
     * 其他：9
     */
    private String payWay;

    /**
     * 计费金额
     */
    private Float chargeMoney;

    /**
     * 缴费金额
     */
    private Float payMoney;

    /**
     * 缴费时间
     */
    private String payTime;

    /**
     * 缴费状态: 缴费：1； 没缴费：0
     */
    private Integer payStatus;

    /**
     * 入口编号
     */
    private String entranceSn;

    /**
     * 停车场名称
     */
    public String parkName;

    /**
     * 出口编号
     */
    public String exitSn;

    /**
     * 离场图片
     */
    private String outRecordUrl;

    /**
     * 入场照片照片链接
     */
    public String intoPhotoUrl;
}
