package com.icetech.partner.domain.request.danyang;

import lombok.Data;

/**
 * 入场数据提交接口
 *
 * @author FGD
 */
@Data
public class EnterRequest {
    /**
     * 停车场编号
     */
    protected String parkCode;
    /**
     * 车牌号，不允许为空
     */
    protected String plateNo;
    /**
     * 入场取票号/无牌车入场的卡号
     */
    protected String cardNo;
    /**
     * 入场时间，不允许为空<br/>
     * (yyyy-MM-dd HH:mm:ss)
     */
    protected String entryTime;
    /**
     * 入口名称/入口ip/入口设备编码  三选一
     */
    protected String entryPlace;
    /**
     * 入口抓拍图片 方式：Base64 / Url<br/>
     * 二选一 可配置是否上传
     */
    protected String imgName;
    /**
     * 车辆类型 1:大型车；2:小型车<br/>
     * (传数值请自行转换)
     */
    protected Integer vplType;
    /**
     * 车牌颜色 0蓝色；1黄色；2白色；3黑色；4绿色；<br/>
     * (传数值请自行转换)
     */
    protected String vplColor;
}
