package com.icetech.partner.domain.request.bst;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2022-11-07 17:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BstAdSpaceVo implements Serializable {

    /**
     * 停车场名称。
     */
    private String parkName;

    /**
     * 停车场编号。流量主自己内部的车场Id，同一流量主下各车场编号不允许重复
     */
    private String parkNumber;

    /**
     * 设备类型 0：公众号；1：小程序； 2：APP；3：缴费机 4：补交机 ；5;电视机；6：支付宝；9;通用设备
     */
    private Integer deviceType;

    /**
     * 触发事件。 0:车牌查询页（输入车牌页面）；1:支付完成页（支付完毕）；2:入场消息推送也；3:出场消息推送页；4:优惠活动广告页； 5:首页广告；6:支付确认（付款前）;7：启动页；9;弹出式广告页面;15：一般页面广告;16:公众号菜单栏;17:线下二维码;32:其他页
     */
    private Integer triggerEvent;

    /**
     * 广告位编号。流量主内部的广告位Id(双方核对数据时用)
     */
    private String spaceNumber;

    /**
     * 广告位名称
     */
    private String spaceName;
}
