package com.icetech.partner.domain.piaotong;

import java.util.List;

import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class InvoiceBlueRequest {
    /**
     * 纳税人识别号
     * String(15-20)
     * 是
     * 开票方纳税人识别号,长度校验规则为字符长度，只能包括大写英文字母或数字
     */
    protected String taxpayerNum;
    /**
     * 发票请求流水号
     * String(20)
     * 是
     * 4位平台简称+16位随机数,长度校验规则为字符长度，只能包括英文字母或数字，唯一
     */
    protected String invoiceReqSerialNo;
    /**
     * 购买方名称
     * String(1-100)
     * 是
     * 票面信息，发票抬头，无默认长度校验规则为GBK字节长度，不能包含<>字符
     */
    protected String buyerName;
    /**
     * 购买方纳税人识别号
     * String(15-20)
     * 否
     * 票面信息，无默认,长度校验规则为字符长度，只能包括大写英文字母或数字
     */
    protected String buyerTaxpayerNum;
    /**
     * 购买方地址
     * String(1-100)
     * 否
     * 票面信息，无默认，长度校验规则为GBK字节长度。
     * buyerAddress、buyerTel两个字段总长度不超100位GBK字节。
     */
    protected String buyerAddress;
    /**
     * 购买方电话
     * String(1-20)
     * 否
     * 票面信息，无默认，长度校验规则为字符长度，只能是数字、中英文括号、中英文横杠。
     * buyerAddress、buyerTel两个字段总长度不超100位GBK字节。
     */
    protected String buyerTel;
    /**
     * 购买方开户行
     * String(1-100)
     * 否
     * 票面信息，无默认，长度校验规则为GBK字节长度。
     * buyerBankName、buyerBankAccount两个字段总长度不超100位GBK字节。
     */
    protected String buyerBankName;
    /**
     * 购买方银行账号
     * String(1-50)
     * 否
     * 票面信息，无默认，长度校验规则为字符长度。
     * buyerBankName、buyerBankAccount两个字段总长度不超100位GBK字节。
     */
    protected String buyerBankAccount;
    /**
     * 销货方地址
     * String(1-100)
     * 否
     * 票面信息，长度校验规则为GBK字节长度。
     * 如果不传值，取平台企业开票设置中的企业开票地址电话信息（如有多条取默认的，没有默认取最后一条）。
     * sellerAddress、sellerTel两个字段总长度不超100位GBK字节。
     */
    protected String sellerAddress;
    /**
     * 销货方电话
     * String(1-20)
     * 否
     * 票面信息，长度校验规则为字符长度，只能是数字、中英文括号、中英文横杠。
     * 如果不传值，取平台企业开票设置中的企业开票地址电话信息（如有多条取默认的，没有默认取最后一条）。
     * sellerAddress、sellerTel两个字段总长度不超100位GBK字节。
     */
    protected String sellerTel;
    /**
     * 销货方开户行
     * String(1-100)
     * 否
     * 票面信息，长度校验规则为GBK字节长度。
     * 如果不传值，取平台企业开票设置中的开户行及银行账号信息（如有多条取默认的，如有一条则使用该开户行及银行账号信息）。
     * sellerBankName、sellerBankAccount两个字段总长度不超100位GBK字节。
     */
    protected String sellerBankName;
    /**
     * 销货方银行账号
     * String(1-50)
     * 否
     * 票面信息，长度校验规则为字符长度。
     * 如果不传值，取平台企业开票设置中的开户行及银行账号信息（如有多条取默认的，如有一条则使用该开户行及银行账号信息）。
     * sellerBankName、sellerBankAccount两个字段总长度不超100位GBK字节。
     */
    protected String sellerBankAccount;
    /**
     * 主开票项目名称
     * String(100)
     * 否
     * 票面信息
     * 如果不填写，会以第一个开票项目为主项目名称，填入票面信息，长度校验规则为GBK字节长度
     */
    protected String itemName;
    /**
     * 收款人名称
     * String(1-16)
     * 否
     * 票面信息
     * 如果不填写，则默认开票设置中的收款人（如果设置了多条，取默认的，没有默认的则为空；如果有一条，则使用该收款人）；
     * 如果填入则根据填入信息填入票面信息，长度校验规则为GBK字节长度
     */
    protected String casherName;
    /**
     * 复核人名称
     * String(1-16)
     * 否
     * 票面信息
     * 如果不填写，则默认开票设置中的复核人（如果设置了多条，取默认的，没有默认的则为空；如果有一条，则使用该复核人）
     * 如果填入则根据填入信息填入票面信息，长度校验规则为GBK字节长度
     */
    protected String reviewerName;
    /**
     * 开票人名称
     * String(1-20)
     * 否
     * 票面信息
     * 如果不填写，会以企业联系人（见注册企业接口的contactsName）填入票面信息，长度校验规则为GBK字节长度
     */
    protected String drawerName;
    /**
     * 收票人名称
     * String(1-10)
     * 否
     * 客户信息，长度校验规则为字符长度
     */
    protected String takerName;
    /**
     * 收票人手机号
     * String(11)
     * 否
     * 客户信息，长度校验规则为字符长度
     */
    protected String takerTel;
    /**
     * 收票人邮箱
     * String(4-50)
     * 否
     * 客户信息
     * 填写后，票通会给客户发送发票邮件，不填写则不发送，长度校验规则为字符长度
     */
    protected String takerEmail;
    /**
     * 特殊票种
     * String(0-240)
     * 否
     * 08：成品油发票（计量单位目前只能为“升”）；
     * 02：农产品收购发票（注：收购发票只能开具税率为0、免税、不征税的发票）；
     * 其他可以为空展示为空，如果填入则根据填入信息填入票面信息，长度校验规则为GBK字节长度
     */
    protected String specialInvoiceKind;
    /**
     * 备注
     * String(0-240)
     * 否
     * 票面信息
     * 如果不填写，票面展示为空，如果填入则根据填入信息填入票面信息，长度校验规则为GBK字节长度
     */
    protected String remark;
    /**
     * 自定义数据
     * String(0-200)
     * 否
     * 自定义数据，在发票推送接口中会按照定义返回，长度校验规则为字符长度
     */
    protected String definedData;
    /**
     * 订单号
     * String(0-200)
     * 否
     * 订单号，长度校验规则为字符长度。
     * 如果没有传值，票通平台默认使用发票请求流水号invoiceReqSerialNo赋值
     */
    protected String tradeNo;
    /**
     * 分机号
     * String(1-10)
     * 否
     * 开票的税盘分机号,不填写将随机获取在线分机的对应分机号
     */
    protected String extensionNum;
    /**
     * 机器编号
     * String(12)
     * 否
     * 开票的税盘机器编号，若传值将校验平台是否存在该机器编号的终端设备
     */
    protected String machineCode;
    /**
     * 代开标示
     * String(0-10)
     * 否
     * 0：自开、
     * 1：代开
     * 不传值默认为0
     */
    protected String agentInvoiceFlag;
    /**
     * 门店编号
     * String（6-20）
     * 否
     * 门店编号，取值集团版门店编号，没有则不用填写。
     * 只允许字母、数字
     */
    protected String shopNum;
    /**
     * 开票项目列表数组或集合
     * 是
     * 最大100行（包括折扣行）
     */
    protected List<Item> itemList;

    @Data
    @Accessors(chain = true)
    public static class Item {
        /**
         * 货物名称
         * String(1-100)
         * 是
         * 票面信息，此项不填写时默认为taxClassificationCode对应的名称，长度校验规则为GBK字节长度
         */
        protected String goodsName;
        /**
         * 对应税收分类编码
         * String(1-50)
         * 是
         * 统一编码表的信息，长度校验规则为字符长度
         */
        protected String taxClassificationCode;
        /**
         * 对应规格型号
         * String(1-40)
         * 否
         * 票面信息，无默认，长度校验规则为GBK字节长度
         */
        protected String specificationModel;
        /**
         * 单位
         * String(1-20)
         * 否
         * 票面信息，无默认，长度校验规则为GBK字节长度
         */
        protected String meteringUnit;
        /**
         * 数量
         * 16位(精确到8位小数)
         * 否
         * 票面信息，支持到小数点前8位。
         * 成品油发票数量不能为空，数量和单价必须同时为空或同时不为空
         */
        protected String quantity;
        /**
         * 含税标示
         * String(1)
         * 否
         * 0：不含税
         * 1：含税
         * 默认为0不含税
         */
        protected String includeTaxFlag;
        /**
         * 单价
         * 16位(精确到8位小数)
         * 否
         * 票面信息，支持到小数点前8位
         * 默认为不含税，可通过含税标示includeTaxFlag，定义此字段为含税。
         * 成品油发票单价不能为空，数量和单价必须同时为空或同时不为空
         */
        protected String unitPrice;
        /**
         * 金额
         * 10位(精确到2位小数)
         * 是
         * 票面信息，支持到小数点前8位
         * 默认为不含税，可通过含税标示includeTaxFlag，定义此字段为含税。
         */
        protected String invoiceAmount;
        /**
         * 税率
         * 4位(精确到2位小数)
         * 是
         * 票面信息，例：0.13
         */
        protected String taxRateValue;
        /**
         * 税额
         * 10位(精确到2位小数)
         * 否
         * 票面信息，如果不填写，默认会根据税率计算税额
         * 如果填写此值会直接使用此税额,可通过含税标示includeTaxFlag，定义此字段为含税
         */
        protected String taxRateAmount;
        /**
         * 折扣金额
         * 10位(精确到2位小数)
         * 否
         * 该商品行的折扣金额，传负数
         */
        protected String discountAmount;
        /**
         * 折扣税额
         * 10位(精确到2位小数)
         * 否
         * 票面信息，使用折扣金额进行计算
         */
        protected String discountTaxRateAmount;
        /**
         * 差额开票抵扣金额
         * 10位(精确到2位小数)
         * 否
         * 差额开票抵扣金额，此值不填写时为非差额开票，填写时为差额开票，
         */
        protected String deductionAmount;
        /**
         * 优惠政策标识
         * String(1-50)
         * 否
         * 空：不使用
         * 1:使用零税率标识为0、1、2时该值必填1。
         */
        protected String preferentialPolicyFlag;
        /**
         * 零税率标识
         * String(1)
         * 否
         * 税率为0时该值必填。
         * 空：非零税率
         * 0：出口零税
         * 1：免税
         * 2：不征税
         * 3：普通零税率
         */
        protected String zeroTaxFlag;
        /**
         * 增值税特殊管理
         * String(0-100)
         * 否
         * preferentialPolicyFlag优惠政策标识位1时必填，填免税、不征税或出口零税
         */
        protected String vatSpecialManage;
    }
}
