package com.icetech.partner.domain.piaotong;

import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class AuthWechatRequest {
    /**
     * 纳税人识别号
     * String(15-20)
     * 是
     * 开票方纳税人识别号
     */
    protected String taxpayerNum;
    /**
     * 发票请求流水号
     * String(20)
     * 是
     * 发票请求流水号4 位平台简称 +16 位随机数
     */
    protected String invoiceReqSerialNo;
    /**
     * 开票开源
     * String(3)
     * 否
     * app：app 开票，
     * web：微信h5 开票，
     * wxa：小程序开发票，
     * wap：普通网页开票
     * 默认wap
     */
    protected String invoiceSource;
}
