package com.icetech.partner.domain.model.kuangu;

import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class NewInvoiceRequest {
    /**
     * 销方纳税人识别号 是
     */
    protected String taxcode;
    /**
     * 销方托管税控设备编号 是
     */
    protected String taxDeceiveSN;
    /**
     * 请求序列号 是
     */
    protected String seqNumber;
    /**
     * 待开具发票信息 是
     */
    protected InvoiceData invoiceData;

    @Getter
    @Setter
    @ToString
    @Accessors(chain = true)
    public static class InvoiceData {
        public static final String ISSUE_TYPE_BLUE = "0";
        public static final String ISSUE_TYPE_RED = "1";
        public static final String INVOICE_TYPE_NORMAL = "4";

        /**
         * 开票类型 是
         * 0：开具正数（蓝字）发票；1：开具负数（红冲）发票或提交专票红字信息表；
         */
        @JSONField(name = "IssueType")
        @JsonProperty("IssueType")
        protected String issueType;
        /**
         * 发票种类 是
         * 4：电子普票
         */
        @JSONField(name = "InvoiceType")
        @JsonProperty("InvoiceType")
        protected String invoiceType;
        /**
         * 销方纳税人识别号 是
         */
        @JSONField(name = "MerchantTaxID")
        @JsonProperty("MerchantTaxID")
        protected String merchantTaxID;
        /**
         * 销方名称 是
         */
        @JSONField(name = "MerchantName")
        @JsonProperty("MerchantName")
        protected String merchantName;
        /**
         * 销方地址 是
         * 地址+电话不超过100字节（每个汉字2字节）
         */
        @JSONField(name = "MerchantAddress")
        @JsonProperty("MerchantAddress")
        protected String merchantAddress;
        /**
         * 销方电话 否
         * 地址+电话不超过100字节（每个汉字2字节）；可并入地址中提供
         */
        @JSONField(name = "MerchantPhone")
        @JsonProperty("MerchantPhone")
        protected String merchantPhone;
        /**
         * 销方银行名称 否
         * 银行名称+银行账号不超过100字 节（每个汉字2字节）
         */
        @JSONField(name = "MerchantBank")
        @JsonProperty("MerchantBank")
        protected String merchantBank;
        /**
         * 销方银行账号 否
         * 银行名称+银行账号不超过100字 节（每个汉字2字节）；可并入银行名称中提供
         */
        @JSONField(name = "MerchantBankAccount")
        @JsonProperty("MerchantBankAccount")
        protected String merchantBankAccount;
        /**
         * 购方纳税人识别号 否
         * 不能为全0
         */
        @JSONField(name = "PurchaserTaxID")
        @JsonProperty("PurchaserTaxID")
        protected String purchaserTaxID;
        /**
         * 购方名称 是
         */
        @JSONField(name = "PurchaserName")
        @JsonProperty("PurchaserName")
        protected String purchaserName;
        /**
         * 购方地址 否
         * 地址+电话不超过100字节（每个汉字2字节）
         */
        @JSONField(name = "PurchaserAddr")
        @JsonProperty("PurchaserAddr")
        protected String purchaserAddr;
        /**
         * 购方电话 否
         * 地址+电话不超过100字节（每个汉字2字节）；可并入地址中提供
         */
        @JSONField(name = "PurchaserPhone")
        @JsonProperty("PurchaserPhone")
        protected String purchaserPhone;
        /**
         * 购方银行名称 否
         * 银行名称+银行账号不超过100字 节（每个汉字2字节）
         */
        @JSONField(name = "PurchaserBank")
        @JsonProperty("PurchaserBank")
        protected String purchaserBank;
        /**
         * 购方银行账号 否
         * 银行名称+银行账号不超过100字 节（每个汉字2字节）；可并入银行名称中提供
         */
        @JSONField(name = "PurchaserAccount")
        @JsonProperty("PurchaserAccount")
        protected String purchaserAccount;
        /**
         * 购方邮箱 否
         */
        @JSONField(name = "PurchaserEmail")
        @JsonProperty("PurchaserEmail")
        protected String purchaserEmail;
        /**
         * 购方手机号码 否
         */
        @JSONField(name = "PurchaserMobile")
        @JsonProperty("PurchaserMobile")
        protected String purchaserMobile;
        /**
         * 合计金额(不含税) 是
         * 2位小数开具红冲发票时，此字段应为负数
         */
        @JSONField(name = "TotalAmountTaxExcluded")
        @JsonProperty("TotalAmountTaxExcluded")
        protected String totalAmountTaxExcluded;
        /**
         * 合计税额 是
         * 2位小数开具红冲发票时，此字段应为负数
         */
        @JSONField(name = "TotalTax")
        @JsonProperty("TotalTax")
        protected String totalTax;
        /**
         * 价税合计 是
         * 2位小数开具红冲发票时，此字段应为负数
         */
        @JSONField(name = "TotalAmount")
        @JsonProperty("TotalAmount")
        protected String totalAmount;
        /**
         * 汇总行税率 否
         */
        @JSONField(name = "SummaryTaxRate")
        @JsonProperty("SummaryTaxRate")
        protected String summaryTaxRate;
        /**
         * 备注 否
         * 开具红字发票时，系统将自动填充 原票代码号码；差额征税和代办退税时，自动填充；只需传入用户备注部分；
         */
        @JSONField(name = "Remarks")
        @JsonProperty("Remarks")
        protected String remarks;
        /**
         * 收款人 否
         * 长度16字节（每个汉字2字节）
         */
        @JSONField(name = "Payee")
        @JsonProperty("Payee")
        protected String payee;
        /**
         * 复核人 否
         * 长度16字节（每个汉字2字节）
         */
        @JSONField(name = "Reviewer")
        @JsonProperty("Reviewer")
        protected String reviewer;
        /**
         * 开票人 是
         * 长度16字节（每个汉字2字节）
         */
        @JSONField(name = "Drawee")
        @JsonProperty("Drawee")
        protected String drawee;
        /**
         * 清单标志 是
         * 0：自动商品数量8项以内时为普通开具；超过8项则使用 清单开具
         */
        @JSONField(name = "ListFlag")
        @JsonProperty("ListFlag")
        protected String listFlag;
        /**
         * 征收类型 是
         * 0：普通开具；1：减按征收；2：差额征收；
         */
        @JSONField(name = "LevyingType")
        @JsonProperty("LevyingType")
        protected String levyingType;
        /**
         * 税率选择原因 否
         * 小规模纳税人按 3%征收率开具发 票时，需选择原因：0：没有3%税率或一般纳税人；1：2020.3.1前发生纳税义务；2：前期已开 3%征收率发票，现冲红或重开的；3：自愿放弃减按 1%优惠政策
         */
        @JSONField(name = "TaxRateReason")
        @JsonProperty("TaxRateReason")
        protected String taxRateReason;
        /**
         * 是否代办退税 是
         * 0：否（默认）；1：代办退税；
         */
        @JSONField(name = "IsCommissionRebate")
        @JsonProperty("IsCommissionRebate")
        protected String isCommissionRebate;
        /**
         * 特殊票种类型 否
         * 0 或空：不是特殊票种（默认）；
         */
        @JSONField(name = "SpecialInvoiceType")
        @JsonProperty("SpecialInvoiceType")
        protected String specialInvoiceType;
        /**
         * 原发票代码 否
         * 开具负数（红冲）发票时提供
         */
        @JSONField(name = "OriginInvoiceCode")
        @JsonProperty("OriginInvoiceCode")
        protected String originInvoiceCode;
        /**
         * 原发票号码 否
         * 开具负数（红冲）发票时提供
         */
        @JSONField(name = "OriginInvoiceNum")
        @JsonProperty("OriginInvoiceNum")
        protected String originInvoiceNum;
        /**
         * 原发票月份 否
         * 开具负数（红冲）发票时提供，格式 yyyyMM
         */
        @JSONField(name = "OriginInvoiceMonth")
        @JsonProperty("OriginInvoiceMonth")
        protected String originInvoiceMonth;
        /**
         * 专票冲红类型 否
         */
        @JSONField(name = "NegSpclInvType")
        @JsonProperty("NegSpclInvType")
        protected String negSpclInvType;
        /**
         * 专票冲红销方税号 否
         */
        @JSONField(name = "NegSpclInvSellerTaxID")
        @JsonProperty("NegSpclInvSellerTaxID")
        protected String negSpclInvSellerTaxID;
        /**
         * 专票冲红销方名称 否
         */
        @JSONField(name = "NegSpclInvSellerName")
        @JsonProperty("NegSpclInvSellerName")
        protected String negSpclInvSellerName;
        /**
         * 专票红字通知单编号 否
         */
        @JSONField(name = "NegSpecialInvoicePermitNum")
        @JsonProperty("NegSpecialInvoicePermitNum")
        protected String negSpecialInvoicePermitNum;
        /**
         * 专票红字通知单提交盘号 否
         */
        @JSONField(name = "NegSpclInvPermitTaxDeviceSn")
        @JsonProperty("NegSpclInvPermitTaxDeviceSn")
        protected String negSpclInvPermitTaxDeviceSn;
        /**
         * 普票冲红原因 是
         * 1：销货退回；2：开票有误；3：应税服务中止；3：应税服务中止；
         */
        @JSONField(name = "NegOrdInvReason")
        @JsonProperty("NegOrdInvReason")
        protected String negOrdInvReason;
        /**
         * 商品列表 是
         * JSONArray
         */
        @JSONField(name = "ItemList")
        @JsonProperty("ItemList")
        protected List<InvoiceDataItem> itemList;
    }

    @Getter
    @Setter
    @ToString
    @Accessors(chain = true)
    public static class InvoiceDataItem {
        /**
         * 商品名称 是
         * 不包含类别简称的商品名称
         */
        @JSONField(name = "ItemName")
        @JsonProperty("ItemName")
        protected String itemName;
        /**
         * 含税单价 否
         * 3位小数
         */
        @JSONField(name = "UnitPrice")
        @JsonProperty("UnitPrice")
        protected String unitPrice;
        /**
         * 单价(不含税) 否
         * 整数+小数不超过15位
         */
        @JSONField(name = "UnitPriceTaxExcluded")
        @JsonProperty("UnitPriceTaxExcluded")
        protected String unitPriceTaxExcluded;
        /**
         * 含税金额 否
         * 2位小数 若为折扣商品，正数票应提供折扣前的原价，负数票应提供折扣后的金额
         */
        @JSONField(name = "Amount")
        @JsonProperty("Amount")
        protected String amount;
        /**
         * 金额(不含税) 是
         * 2位小数 若为折扣商品，正数票应提供折扣前的原价，负数票应提供折扣后的金额
         */
        @JSONField(name = "AmountTaxExcluded")
        @JsonProperty("AmountTaxExcluded")
        protected String amountTaxExcluded;
        /**
         * 数量 否
         */
        @JSONField(name = "Quantity")
        @JsonProperty("Quantity")
        protected String quantity;
        /**
         * 税率 是
         * 3位小数
         */
        @JSONField(name = "TaxRate")
        @JsonProperty("TaxRate")
        protected String taxRate;
        /**
         * 税额 是
         * 2位小数
         */
        @JSONField(name = "Tax")
        @JsonProperty("Tax")
        protected String tax;
        /**
         * 规格型号 否
         * 长度36字节
         */
        @JSONField(name = "Specifications")
        @JsonProperty("Specifications")
        protected String specifications;
        /**
         * 单位 否
         * 长度22字节
         */
        @JSONField(name = "Unit")
        @JsonProperty("Unit")
        protected String unit;
        /**
         * 折扣金额（不含税） 否
         * 折扣商品不含税金额的扣除额；该字段非零时，表示此商品为折扣商品；2 位小数（正数）；开具红字发票时，商品金额应为折扣后的金额，本字段无效；
         */
        @JSONField(name = "DiscountAmountTaxExcluded")
        @JsonProperty("DiscountAmountTaxExcluded")
        protected String discountAmountTaxExcluded;
        /**
         * 含税折扣金额 否
         * 2位小数（正数）；DiscountAmountTaxExcluded非零时此字段有效；
         */
        @JSONField(name = "DiscountAmount")
        @JsonProperty("DiscountAmount")
        protected String discountAmount;
        /**
         * 折扣税额 否
         * 2位小数（正数）；DiscountAmountTaxExcluded非零时此字段有效；
         */
        @JSONField(name = "DiscountTax")
        @JsonProperty("DiscountTax")
        protected String discountTax;
        /**
         * 差额征收扣除额 否
         * 为价税合计中的不征税部分（正数）。征收类型为差额征收时有效
         */
        @JSONField(name = "TaxExcludingAmount")
        @JsonProperty("TaxExcludingAmount")
        protected String taxExcludingAmount;
        /**
         * 商品分类名称 否
         */
        @JSONField(name = "CatalogName")
        @JsonProperty("CatalogName")
        protected String catalogName;
        /**
         * 商品分类编码 是
         * 必须为《商品和服务税收分类与编码》中定义的商品编码，且不能为汇总项。
         */
        @JSONField(name = "CatalogCode")
        @JsonProperty("CatalogCode")
        protected String catalogCode;
        /**
         * 商品自行编码 否
         */
        @JSONField(name = "CustomCatalogCode")
        @JsonProperty("CustomCatalogCode")
        protected String customCatalogCode;
        /**
         * 优惠政策标识 否
         * 0：不使用；1：使用
         */
        @JSONField(name = "HasPreferentialPolicy")
        @JsonProperty("HasPreferentialPolicy")
        protected String hasPreferentialPolicy;
        /**
         * 优惠政策类型 否
         * 优惠政策标识为1时必须提供 免税；不征税；稀土产品；先征后退；50%先征后退；100%先征后退；即征即退30%；即征即退50%；即征即退70%；即征即退100%；超税负3%即征即退；超税负8%即征即退；超税负12%即征即退；简易征收；按3%简易征收；按5%简易征收；按5%简易征收减按1.5%计征；
         */
        @JSONField(name = "PreferentialPolicy")
        @JsonProperty("PreferentialPolicy")
        protected String preferentialPolicy;
        /**
         * 免税类型 否
         * 空：非0税率；0：出口退税；1：免税（包含出口免税）；2：不征税；3：普通零税率；
         */
        @JSONField(name = "TaxFreeType")
        @JsonProperty("TaxFreeType")
        protected String taxFreeType;
    }
}
