package com.icetech.partner.api.response.rule;

import com.icetech.partner.api.request.open.rule.LedSoundRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description QueryLedSoundResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 18:29
 */
@Data
public class QueryLedSoundResponse implements Serializable {

    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "音量配置，音量值范围1~10，声音依次由弱到强，默认为10", required = true, example = "8", position = 2)
    private Integer volumeValue;

    @ApiModelProperty(value = "勿扰模式是否开启，0不开启，1开启，默认为0", required = true, example = "1", position = 3)
    private Integer quietHoursSwitch;

    @ApiModelProperty(value = "勿扰模式开始时间，24小时制，如21:00；", example = "1", position = 4)
    private String quietStartTime;

    @ApiModelProperty(value = "勿扰模式结束时间，24小时制，如07:00；；", example = "1", position = 5)
    private String quietEndTime;

    @ApiModelProperty(value = "勿扰模式音量值，范围1~10，默认为1", example = "1", position = 6)
    private Integer quietVolumeValue;

    @ApiModelProperty(value = "语音配置", example = "", position = 7)
    private List<LedSoundRequest.SoundConfig> soundConfig;

    @Data
    public static class SoundConfig implements Serializable {
        @ApiModelProperty(value = "播放类型 1：入场临时车、2：入场月卡车/内部车辆、3：入场无牌车、4：入场特殊车辆、5：出场收费车辆、6：出场支付成功、7：出场月卡车、8：出场无牌车、9：免费车辆（临时/特殊）、10" +
                ".出场查无入场记录、11：临时车禁止通行、12：多位多车车位占用、13黑名单车辆进出场", required = true, example = "1", position = 1)
        private Integer soundType;

        @ApiModelProperty(value = "动态内容编号和播放序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：需支付金额、9.一路平安、10" +
                ".欢迎光临11请等待人工确认（比如：”4_1+5_3”,动态内容需要播放车牌号和车辆类型，车牌号排第一播放，车辆类型排第三播放）", required = true, example = "4_1+5_3", position = 2)
        private String dynamicContent;

        @ApiModelProperty(value = "自定义内容和播放序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一路平安_2+注意安全_4”,自定义内容中一路平安排第二播放，注意安全排第四播放)", required = true, example = "一路平安_2+注意安全_4",
                position = 3)
        private String customContent;

    }
}
