package com.icetech.partner.api.response.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class NotificationRespData implements Serializable {
    public static final int CONFIRM_SUCCESS = 0;
    public static final int CONFIRM_FAILED = 1;
    public static final int AUTH_NONE = 0;
    public static final int AUTH_SUCCESS = 1;
    public static final int AUTH_FAILED = 2;
    public static final int REASON_NONE = 0;
    public static final int REASON_NOT_FOUND_PLATE = 1;
    public static final int REASON_NO_PARK_PERM = 2;
    public static final int REASON_NO_FOUND_PARK = 3;
    public static final int REASON_COUPON_EXISTS = 4;
    public static final int REASON_COUPON_FAILED = 5;
    public static final int REASON_COUPON_NONE = 6;
    public static final int REASON_PARAM_ERROR = 7;
    public static final int REASON_REQUEST_MUCH = 8;
    public static final int REASON_SYSTEM_ERROR = 9;
    public static final int REASON_UNKNOWN = 10;

    /**
     * <p>充电订单号</p>
     * <p>充电运营商订单号，即停车票编号，特来电的格式：8位日期+10位序列号</p>
     * <p>必填: 是</p>
     * <p>长度: 27</p>
     */
    protected String startChargeSeq;
    /**
     * <p>确认结果</p>
     * <p>0:成功 1:失败</p>
     * <p>必填: 是</p>
     * <p>长度:  </p>
     */
    protected Integer confirmResult;
    /**
     * <p>车牌鉴权结果</p>
     * <p>0：未鉴权、1：鉴权通过、2：鉴权不通过</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer plateAutResult;
    /**
     * <p>鉴权失败原因</p>
     * <dl>
     *     <dt>鉴权失败原因，返回如下错误码：</dt>
     *     <dd>0:无（鉴权通过或未鉴权）</dd>
     *     <dd>1:车辆不在停车场</dd>
     *     <dd>2:无该停车场权限</dd>
     *     <dd>3:停车场标识不正确</dd>
     *     <dd>4:优惠券已下发，请勿重复下发</dd>
     *     <dd>5:优惠券生成失败</dd>
     *     <dd>6:优惠券已用完</dd>
     *     <dd>7:参数异常</dd>
     *     <dd>8:请勿在短时间内频繁操作</dd>
     *     <dd>9:服务器内部异常</dd>
     *     <dd>10:未知</dd>
     * </dl>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer plateAutFailReason;
}
