package com.icetech.partner.api.response.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class ConsumedRespData implements Serializable {
    public static final int SUCC_STAT_SUCCESS = 0;
    public static final int SUCC_STAT_FAILED = 1;
    
    /**
     * <p>充电订单号</p>
     * <p>充电运营商订单号，特来电的格式：8位日期+10位序列号，用来识别停车票订单</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String StartChargeSeq;
    /**
     * <p>车牌号</p>
     * <p>需兼容新能源车牌号</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String PlateNum;
    /**
     * <p>成功状态</p>
     * <p>0：成功；1：失败</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer SuccStat;
    /**
     * <p>失败原因</p>
     * <dl>
     *     <dt>失败原因：</dt>
     *     <dd>0：无</dd>
     *     <dd>1：停车票已使用</dd>
     *     <dd>2：停车票已作废</dd>
     *     <dd>3：停车票不存在</dd>
     *     <dd>4：停车票已过期</dd>
     *     <dd>5：停车票不可用</dd>
     *     <dd>6：服务器异常</dd>
     *     <dd>7：未知（默认，匹配不到情况）</dd>
     *     <dd>8：无场站权限</dd>
     * </dl>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer FailReason;
}
