package com.icetech.partner.api.response.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description RegionListResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/18 10:58
 */
@Data
public class RegionListResponse implements Serializable {

    @ApiModelProperty(value = "总记录数", required = true, example = "100", position = 1)
    private Long total;

    @ApiModelProperty(value = "总页数", required = true, example = "10", position = 2)
    private String totalPage;

    @ApiModelProperty(value = "返回数据结果", required = true, position = 3)
    private List<RegionListItem> rows;

    @Data
    public static class RegionListItem implements Serializable {

        @ApiModelProperty(value = "分区编号", required = true, example = "100003", position = 1)
        private String regionCode;
        
        @ApiModelProperty(value = "停车场编号", required = true, example = "P1000001", position = 2)
        private String parkCode;

        @ApiModelProperty(value = "区域名称", required = true, example = "北区域", position = 3)
        private String regionName;

        @ApiModelProperty(value = "区域泊位总数", required = true, example = "100", position = 4)
        private Integer regionPark;

        @ApiModelProperty(value = "是否有子区域 1：有 2：无", required = true, example = "1", position = 5)
        private Integer hasInner;

        @ApiModelProperty(value = "子区域数据 hasInner==1是此参数必填", required = false, example = "1")
        private List<SonData> sonData;
        
        @Data
        public static class SonData implements Serializable {

            @ApiModelProperty(value = "子区域名称", required = true, example = "北1区域", position = 1)
            private String regionName;

            @ApiModelProperty(value = "子分区编号", required = true, example = "1222211", position = 2)
            private String regionCode;

            @ApiModelProperty(value = "子区域泊位总数", required = true, example = "3")
            private Integer regionPark;
        }
    }
}
