package com.icetech.partner.api.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @author fangct
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class QingdaoCtFeeResponse {
    /**
     * 订单开始时间(格式:
     * yyyy/mm/dd
     * hh:mm:ss)
     */
    private String start_time;
    /**
     * 场库侧订单编号
     */
    private String barrier_order_no;
    private String plate_no;
    /**
     * 收费类型分为：0-正
     * 常收费、1-离场超时
     */
    private Integer charge_type;
    private Integer billing_duration;
    private Integer parking_fee;
    private Integer pay_fee;
    private String operator_id;
    private List<ReductionInfo> reduction_info;

    @Getter
    @Setter
    public static class ReductionInfo {
        private Long reduction_id;
        private Integer reduction_fee;
    }
}
