package com.icetech.partner.api.request.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class ConsumedReqData implements Serializable {
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    /**
     * <p>充电订单号</p>
     * <p>充电运营商订单号，特来电的格式：8位日期+10位序列号，用来识别停车票订单</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String startChargeSeq;
    /**
     * <p>电站编号</p>
     * <p>充电运营商定义的电站唯一编码（停车场编号和电站编号必须填写一项）</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected String stationID;
    /**
     * <p>停车场编号</p>
     * <p>充电运营商定义的电站唯一编码（停车场编号和电站编号必须填写一项）</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected String parkID;
    /**
     * <p>车牌号</p>
     * <p>需兼容新能源车牌号</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String plateNum;
    /**
     * <p>出场时间</p>
     * <p>车辆离开停车场时间，式“yyyy-MM-dd HH:mm:ss”</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected String leavingTime;
    /**
     * <p>停车减免方式</p>
     * <p>减免停车费的计算方式：1：根据时长减免、2：根据费用减免、3：停车场决定</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer calculationMethod;
    /**
     * <p>实际停车减免金额</p>
     * <p>停车减免金额，单位为元</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected Double parkFreeAmount;
    /**
     * <p>实际停车减免时长</p>
     * <p>停车减免时长，单位为分钟</p>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected Integer parkFreeTime;
}
