package com.icetech.partner.api.request.open.rule;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * Description LedDisplayRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 15:59
 */
@Data
public class LedDisplayRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @NotNull(message = "显示屏行数不能为空")
    @ApiModelProperty(value = "显示屏行数（目前只支持2或4），默认是2", required = true, example = "10", position = 2)
    private Integer ledLineNum;

    @NotNull(message = "ledRemainDaysMc不能为空")
    @ApiModelProperty(value = "月卡剩余多少天进行提示，默认是0,0表示不受限制", required = true, example = "10", position = 3)
    private Integer ledRemainDaysMc;

    @NotNull(message = "ledExpireDaysMc不能为空")
    @ApiModelProperty(value = "月卡过期小于多少天进行提示，默认是0,0表示不受限制", required = true, example = "10", position = 4)
    private Integer ledExpireDaysMc;

    @NotNull(message = "ledBlackCar不能为空")
    @ApiModelProperty(value = "黑名单车辆信息是否提示，0提示，1不提示，默认为0", required = true, example = "1", position = 5)
    private Integer ledBlackCar;

    @NotNull(message = "ledRestoreDefaultTime不能为空")
    @ApiModelProperty(value = "恢复空闲显示时长，单位是秒，默认是90s", required = true, example = "90", position = 6)
    private Integer ledRestoreDefaultTime;

    @NotNull(message = "ledQrcodeRule不能为空")
    @ApiModelProperty(value = "二维码是否显示，0不显示，1显示，默认为0", required = true, example = "1", position = 7)
    private Integer ledQrcodeRule;

    @ApiModelProperty(value = "限行类型，0是尾号限行，1是单双号限行", example = "1", position = 8)
    private Integer limitType;

    @ApiModelProperty(value = "周一限行信息，尾号限行必传 如4和9", example = "4和9", position = 9)
    private String limitDriveNum1;

    @ApiModelProperty(value = "周二限行信息，尾号限行必传", example = "4和9", position = 10)
    private String limitDriveNum2;

    @ApiModelProperty(value = "周三限行信息，尾号限行必传", example = "4和9", position = 11)
    private String limitDriveNum3;

    @ApiModelProperty(value = "周四限行信息，尾号限行必传", example = "4和9", position = 11)
    private String limitDriveNum4;

    @ApiModelProperty(value = "周五限行信息，尾号限行必传", example = "4和9", position = 11)
    private String limitDriveNum5;

    @NotNull
    @ApiModelProperty(value = "屏显配置", required = true, example = "", position = 12)
    private List<LedConfig> ledConfig;

    @NotNull
    @ApiModelProperty(value = "屏显特殊配置", required = true, example = "", position = 13)
    private LedSpecial ledSpecial;
    
    @Data
    public static class LedConfig implements Serializable {

        @NotNull(message = "显示类型不能为空")
        @ApiModelProperty(value = "显示类型 1：入口空闲显示、2：出口空闲显示、3：入场显示、4：出场显示", required = true, example = "1", position = 1)
        private Integer displayType;

        @NotNull(message = "rowNum不能为空")
        @ApiModelProperty(value = "显示在第几行，1：第一行、2：第二行、3：第三行、4：第四行，目前最多有4行", required = true, example = "1", position = 2)
        private Integer rowNum;

        @NotNull(message = "ledColor不能为空")
        @ApiModelProperty(value = "显示颜色1：红色，2：绿色，3：黄色，4：蓝色（只有LCD屏有蓝色），LED屏默认第一、三行是1（红色），二、四行时2（绿色）,LCD屏默认第一行蓝色，第二行绿色，第三行红色", required = true, example = "1", position = 3)
        private Integer ledColor;

        @NotBlank(message = "dynamicContent不能为空")
        @ApiModelProperty(value = "动态内容编号和显示序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：入场提示、9：缴费/出场提示、10：需支付金额、11" +
                "：停车场名称、12：储值卡余额（比如：”4_1+5_3”,动态内容需要显示车牌号和车辆类型，车牌号排第一显示，车辆类型排第三显示）", required = true, example = "1", position = 4)
        private String dynamicContent;

        @NotBlank(message = "customContent不能为空")
        @ApiModelProperty(value = "自定义内容和显示序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一路平安_2+注意安全_4”,自定义内容中一路平安排第二显示，注意安全排第四显示)", required = true, example = "1", position = 5)
        private String customContent;
    }
    
    @Data
    public static class LedSpecial implements Serializable {

        @NotBlank(message = "enterTmpSpecial不能为空")
        @ApiModelProperty(value = "入场临时车/特殊车辆，默认：欢迎光临", required = true, example = "欢迎光临", position = 1)
        private String enterTmpSpecial;

        @NotBlank(message = "enterMonthVip不能为空")
        @ApiModelProperty(value = "入场月卡车/内部车，默认：欢迎光临", required = true, example = "欢迎光临", position = 2)
        private String enterMonthVip;

        @NotBlank(message = "enterNotAllowTmpRun不能为空")
        @ApiModelProperty(value = "入场临时车禁止入场，默认：非月卡车禁止入内", required = true, example = "非月卡车禁止入内", position = 3)
        private String enterNotAllowTmpRun;

        @NotBlank(message = "enterMultiParkCar不能为空")
        @ApiModelProperty(value = "入场多卡多车情况，车位被占用提示，默认：车位已占", required = true, example = "车位已占", position = 4)
        private String enterMultiParkCar;

        @NotBlank(message = "enterBlackCar不能为空")
        @ApiModelProperty(value = "入场黑名单提示，默认：禁止通行", required = true, example = "禁止通行", position = 5)
        private String enterBlackCar;

        @NotBlank(message = "enterMonthExpire不能为空")
        @ApiModelProperty(value = "入场月卡过期提示，默认：月卡车已过期", required = true, example = "月卡车已过期", position = 6)
        private String enterMonthExpire;

        @NotBlank(message = "enterNoParkingSpace不能为空")
        @ApiModelProperty(value = "入场没有空车位提示信息，默认：车位已满 禁止入内", required = true, example = "车位已满 禁止入内", position = 7)
        private String enterNoParkingSpace;

        @NotBlank(message = "enterNotAllowNocarRun不能为空")
        @ApiModelProperty(value = "无牌车入场提示，默认：请扫码入场", required = true, example = "请扫码入场", position = 8)
        private String enterNotAllowNocarRun;

        @NotBlank(message = "exitPay不能为空")
        @ApiModelProperty(value = "出场缴费提示，默认：请扫码缴费", required = true, example = "请扫码缴费", position = 9)
        private String exitPay;

        @NotBlank(message = "exitOpenGate不能为空")
        @ApiModelProperty(value = "出场开闸提示，默认：一路平安", required = true, example = "一路平安", position = 10)
        private String exitOpenGate;

        @NotBlank(message = "exitNoEnterinfo不能为空")
        @ApiModelProperty(value = "出场无在场记录，默认：无入场信息/请呼叫管理员", required = true, example = "无入场信息/请呼叫管理员", position = 11)
        private String exitNoEnterinfo;

        @NotBlank(message = "exitNoCarplate不能为空")
        @ApiModelProperty(value = "无牌车出场，默认：请扫码出场", required = true, example = "请扫码出场", position = 12)
        private String exitNoCarplate;
    }
}
